/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.task;

import io.aleph0.yap.core.task.DefaultTaskController;
import io.aleph0.yap.core.task.TaskController;
import io.aleph0.yap.core.transport.Queue;
import java.time.Duration;

public class DefaultConsumerTaskController<InputT>
extends DefaultTaskController<InputT, Void> {
    public static <InputT> Builder<InputT> builder() {
        return new Builder();
    }

    public DefaultConsumerTaskController(int parallelism, Duration heartbeatInterval, Queue<InputT> queue) {
        super(parallelism, heartbeatInterval, queue, null);
    }

    public static class Builder<InputT>
    implements TaskController.ConsumerTaskControllerBuilder<InputT> {
        private int desiredConcurrency = 1;
        private Duration heartbeatInterval = Duration.ofSeconds(60L);

        public Builder<InputT> setDesiredConcurrency(int parallelism) {
            if (parallelism < 1) {
                throw new IllegalArgumentException("desiredConcurrency must be at least 1");
            }
            this.desiredConcurrency = parallelism;
            return this;
        }

        public Builder<InputT> setHeartbeatInterval(Duration heartbeatInterval) {
            if (heartbeatInterval == null) {
                throw new NullPointerException();
            }
            if (!heartbeatInterval.isPositive()) {
                throw new IllegalArgumentException("heartbeatInterval must be positive");
            }
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        @Override
        public DefaultConsumerTaskController<InputT> build(Queue<InputT> queue) {
            return new DefaultConsumerTaskController<InputT>(this.desiredConcurrency, this.heartbeatInterval, queue);
        }
    }
}

