/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.pipeline;

import io.aleph0.yap.core.Measureable;
import io.aleph0.yap.core.pipeline.PipelineController;
import io.aleph0.yap.core.pipeline.action.CancelPipelineAction;
import io.aleph0.yap.core.pipeline.action.CancelTaskPipelineAction;
import io.aleph0.yap.core.pipeline.action.FailPipelineAction;
import io.aleph0.yap.core.pipeline.action.PipelineAction;
import io.aleph0.yap.core.pipeline.action.StartTaskPipelineAction;
import io.aleph0.yap.core.pipeline.action.SucceedPipelineAction;
import io.aleph0.yap.core.task.TaskManager;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineManager
implements Measureable<Metrics> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineManager.class);
    private final int id;
    private final ExecutorService executor;
    private final PipelineController controller;
    private final List<TaskManager<?>> taskBodies;
    private final Map<String, Future<?>> runningTasks = new ConcurrentHashMap();
    private final BlockingQueue<PipelineEvent> events = new LinkedBlockingQueue<PipelineEvent>();
    private final List<LifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<LifecycleListener>();
    private volatile PipelineState state = PipelineState.READY;
    private ExecutionException failureCause;

    public PipelineManager(int id, ExecutorService executor, PipelineController controller, List<TaskManager<?>> tasks) {
        this.id = id;
        this.executor = Objects.requireNonNull(executor);
        this.controller = Objects.requireNonNull(controller);
        this.taskBodies = Collections.unmodifiableList(tasks);
    }

    public int getId() {
        return this.id;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.lifecycleListeners.add(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
    }

    public void run() throws Exception {
        try {
            for (TaskManager<?> taskBody : this.taskBodies) {
                taskBody.addLifecycleListener(new WorkerLifecycleListener());
            }
            this.state = this.state.to(PipelineState.RUNNING);
            LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).log("Pipeline manager started");
            List<PipelineAction> actions = this.controller.onPipelineStarted();
            this.notifyLifecycleListeners(listener -> listener.onPipelineStarted(this.id));
            this.eventLoop(actions);
            switch (this.state.ordinal()) {
                case 2: {
                    LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).log("Pipeline completed");
                    this.controller.onPipelineCompleted();
                    this.notifyLifecycleListeners(listener -> listener.onPipelineCompleted(this.id));
                    break;
                }
                case 3: {
                    LOGGER.atWarn().addKeyValue("pipeline", (Object)this.id).log("Pipeline cancelled, but without cancel request");
                    this.controller.onPipelineCancelled();
                    this.notifyLifecycleListeners(listener -> listener.onPipelineCancelled(this.id));
                    break;
                }
                case 4: {
                    LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).setCause((Throwable)this.failureCause).log("Pipeline failed");
                    this.controller.onPipelineFailed(this.failureCause);
                    this.notifyLifecycleListeners(listener -> listener.onPipelineFailed(this.id, this.failureCause));
                    break;
                }
                default: {
                    throw new IllegalStateException("Pipeline manager in invalid state after run: " + String.valueOf((Object)this.state));
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.atInfo().addKeyValue("pipeline", (Object)this.id).log("Pipeline manager interrupted, treating as cancel request");
            if (this.state.getPhase() != PipelinePhase.FINISHED) {
                List<PipelineAction> actions = this.controller.onCancelRequested();
                this.eventLoop(actions);
            }
            switch (this.state.ordinal()) {
                case 2: {
                    LOGGER.atWarn().addKeyValue("pipeline", (Object)this.id).log("Pipeline completed, but after cancel request");
                    this.controller.onPipelineCompleted();
                    this.notifyLifecycleListeners(listener -> listener.onPipelineCompleted(this.id));
                    break;
                }
                case 3: {
                    LOGGER.atInfo().addKeyValue("pipeline", (Object)this.id).log("Pipeline cancelled");
                    this.controller.onPipelineCancelled();
                    this.notifyLifecycleListeners(listener -> listener.onPipelineCancelled(this.id));
                    break;
                }
                case 4: {
                    LOGGER.atWarn().addKeyValue("pipeline", (Object)this.id).setCause((Throwable)this.failureCause).log("Pipeline failed, but after cancel request");
                    this.controller.onPipelineFailed(this.failureCause);
                    this.notifyLifecycleListeners(listener -> listener.onPipelineFailed(this.id, this.failureCause));
                    break;
                }
                default: {
                    throw new IllegalStateException("Pipeline manager in invalid state after interrupt: " + String.valueOf((Object)this.state));
                }
            }
        }
        catch (Exception e) {
            LOGGER.atError().addKeyValue("pipeline", (Object)this.id).setCause((Throwable)e).log("Pipeline manager failed; hard failing pipeline, canceling all tasks, and propagating exception...");
            this.state = PipelineState.FAILED;
            for (Future<?> taskFuture : this.runningTasks.values()) {
                taskFuture.cancel(true);
            }
            this.notifyLifecycleListeners(listener -> listener.onPipelineFailed(this.id, e));
            throw e;
        }
        if (this.state == PipelineState.FAILED && this.failureCause != null) {
            LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).setCause((Throwable)this.failureCause).log("Pipeline failed with exception, propagating...");
            Throwable cause = this.failureCause.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw this.failureCause;
        }
    }

    private void eventLoop(List<PipelineAction> initialActions) throws InterruptedException {
        for (PipelineAction action : initialActions) {
            this.performPipelineAction(action);
        }
        while (this.state == PipelineState.RUNNING) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                throw new InterruptedException();
            }
            PipelineEvent event = this.events.poll(this.controller.getHeartbeatInterval().toMillis(), TimeUnit.MILLISECONDS);
            List<PipelineAction> actions = this.handleTaskEvent(event);
            for (PipelineAction action : actions) {
                this.performPipelineAction(action);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<PipelineAction> handleTaskEvent(PipelineEvent event) {
        void var2_21;
        PipelineEvent pipelineEvent = event;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TaskStartedEvent.class, TaskCompletedEvent.class, TaskFailedEvent.class, TaskCancelledEvent.class, WorkerLifecycleEvent.class}, (Object)pipelineEvent, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String taskId;
                TaskStartedEvent taskStartedEvent = (TaskStartedEvent)pipelineEvent;
                try {
                    String string;
                    taskId = string = taskStartedEvent.id();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).addKeyValue("task", (Object)taskId).log("Task started");
                List<PipelineAction> list = this.controller.onTaskStarted(taskId);
                this.notifyLifecycleListeners(listener -> listener.onPipelineTaskStarted(this.id, taskId));
                return var2_21;
            }
            case 1: {
                String taskId;
                TaskCompletedEvent taskCompletedEvent = (TaskCompletedEvent)pipelineEvent;
                {
                    String string;
                    taskId = string = taskCompletedEvent.id();
                }
                LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).addKeyValue("task", (Object)taskId).log("Task completed");
                this.runningTasks.remove(taskId);
                List<PipelineAction> list = this.controller.onTaskCompleted(taskId);
                this.notifyLifecycleListeners(listener -> listener.onPipelineTaskCompleted(this.id, taskId));
                return var2_21;
            }
            case 2: {
                Object cause;
                String taskId;
                TaskFailedEvent taskFailedEvent = (TaskFailedEvent)pipelineEvent;
                {
                    Object object = taskFailedEvent.id();
                    taskId = object;
                    cause = object = taskFailedEvent.cause();
                }
                LOGGER.atError().addKeyValue("pipeline", (Object)this.id).addKeyValue("task", (Object)taskId).setCause((Throwable)cause).log("Task failed");
                this.runningTasks.remove(taskId);
                List<PipelineAction> list = this.controller.onTaskFailed(taskId, (Throwable)cause);
                this.notifyLifecycleListeners(arg_0 -> this.lambda$handleTaskEvent$10(taskId, (Throwable)cause, arg_0));
                return var2_21;
            }
            case 3: {
                Object taskId;
                Object object;
                TaskCancelledEvent taskCancelledEvent = (TaskCancelledEvent)pipelineEvent;
                {
                    taskId = object = taskCancelledEvent.id();
                }
                LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).addKeyValue("task", taskId).log("Task cancelled");
                this.runningTasks.remove(taskId);
                List<PipelineAction> list = this.controller.onTaskCancelled((String)taskId);
                this.notifyLifecycleListeners(arg_0 -> this.lambda$handleTaskEvent$11((String)taskId, arg_0));
                return var2_21;
            }
            case 4: {
                Consumer<LifecycleListener> e;
                int workerId;
                String taskId;
                Object object = (WorkerLifecycleEvent)pipelineEvent;
                {
                    Consumer<LifecycleListener> consumer;
                    int n2;
                    String string;
                    taskId = string = ((WorkerLifecycleEvent)object).taskId();
                    int n3 = n2 = ((WorkerLifecycleEvent)object).workerId();
                    workerId = n2;
                    e = consumer = ((WorkerLifecycleEvent)object).event();
                }
                LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).addKeyValue("task", (Object)taskId).addKeyValue("worker", (Object)workerId).log("Worker lifecycle event");
                List list = Collections.emptyList();
                this.notifyLifecycleListeners(e);
                return var2_21;
            }
            case -1: 
        }
        LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).log("Heartbeat");
        List<PipelineAction> list = this.controller.onHeartbeat();
        return var2_21;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void performPipelineAction(PipelineAction action) throws InterruptedException {
        PipelineAction pipelineAction = action;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StartTaskPipelineAction.class, CancelTaskPipelineAction.class, SucceedPipelineAction.class, CancelPipelineAction.class, FailPipelineAction.class}, (Object)pipelineAction, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String taskId;
                StartTaskPipelineAction startTaskPipelineAction = (StartTaskPipelineAction)pipelineAction;
                try {
                    String string;
                    taskId = string = startTaskPipelineAction.id();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).addKeyValue("task", (Object)taskId).log("Starting pipeline task");
                TaskManager taskBody = this.taskBodies.stream().filter(task -> task.getId().equals(taskId)).findFirst().orElseThrow();
                TaskRunner task2 = new TaskRunner(taskBody);
                Future<?> taskFuture = this.executor.submit(task2);
                this.runningTasks.put(taskId, taskFuture);
                return;
            }
            case 1: {
                String taskId;
                Object taskFuture;
                CancelTaskPipelineAction cancelTaskPipelineAction = (CancelTaskPipelineAction)pipelineAction;
                {
                    taskFuture = cancelTaskPipelineAction.id();
                    taskId = taskFuture;
                }
                LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).addKeyValue("task", (Object)taskId).log("Cancelling pipeline task");
                taskFuture = Optional.ofNullable(this.runningTasks.get(taskId)).orElseThrow();
                taskFuture.cancel(true);
                return;
            }
            case 2: {
                SucceedPipelineAction succeedPipelineAction = (SucceedPipelineAction)pipelineAction;
                LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).log("Succeeded pipeline");
                this.state = this.state.to(PipelineState.COMPLETED);
                return;
            }
            case 3: {
                CancelPipelineAction cancelPipelineAction = (CancelPipelineAction)pipelineAction;
                LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).log("Cancelled pipeline");
                this.state = this.state.to(PipelineState.CANCELLED);
                return;
            }
            case 4: {
                ExecutionException cause;
                FailPipelineAction failPipelineAction = (FailPipelineAction)pipelineAction;
                {
                    ExecutionException executionException;
                    cause = executionException = failPipelineAction.cause();
                }
                LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).setCause((Throwable)cause).log("Failed pipeline");
                this.state = this.state.to(PipelineState.FAILED);
                this.failureCause = cause;
                return;
            }
            case -1: 
        }
        LOGGER.atDebug().addKeyValue("pipeline", (Object)this.id).log("Do nothing");
    }

    private void notifyLifecycleListeners(Consumer<LifecycleListener> event) {
        for (LifecycleListener listener : this.lifecycleListeners) {
            try {
                event.accept(listener);
            }
            catch (Exception e) {
                LOGGER.atError().setCause((Throwable)e).log("Lifecycle listener threw exception");
            }
        }
    }

    @Override
    public Metrics checkMetrics() {
        PipelineState state = this.state;
        PipelinePhase phase = state.getPhase();
        HashMap<String, Object> taskMetrics = new HashMap<String, Object>();
        for (TaskManager<?> task : this.taskBodies) {
            taskMetrics.put(task.getId(), task.checkMetrics());
        }
        return new Metrics(this.id, phase, state, Collections.unmodifiableMap(taskMetrics));
    }

    @Override
    public Metrics flushMetrics() {
        Metrics result = this.checkMetrics();
        for (TaskManager<?> task : this.taskBodies) {
            task.flushMetrics();
        }
        return result;
    }

    private /* synthetic */ void lambda$handleTaskEvent$11(String taskId, LifecycleListener listener) {
        listener.onPipelineTaskCancelled(this.id, taskId);
    }

    private /* synthetic */ void lambda$handleTaskEvent$10(String taskId, Throwable cause, LifecycleListener listener) {
        listener.onPipelineTaskFailed(this.id, taskId, cause);
    }

    public static enum PipelineState {
        READY(PipelinePhase.READY){

            @Override
            public PipelineState to(PipelineState target) {
                if (target != RUNNING) {
                    throw new IllegalStateException("Invalid transition from READY to " + String.valueOf((Object)target));
                }
                return target;
            }
        }
        ,
        RUNNING(PipelinePhase.RUNNING){

            @Override
            public PipelineState to(PipelineState target) {
                if (target != COMPLETED && target != CANCELLED && target != FAILED) {
                    throw new IllegalStateException("Invalid transition from RUNNING to " + String.valueOf((Object)target));
                }
                return target;
            }
        }
        ,
        COMPLETED(PipelinePhase.FINISHED){

            @Override
            public PipelineState to(PipelineState target) {
                throw new IllegalStateException("Invalid transition from COMPLETED to " + String.valueOf((Object)target));
            }
        }
        ,
        CANCELLED(PipelinePhase.FINISHED){

            @Override
            public PipelineState to(PipelineState target) {
                throw new IllegalStateException("Invalid transition from CANCELLED to " + String.valueOf((Object)target));
            }
        }
        ,
        FAILED(PipelinePhase.FINISHED){

            @Override
            public PipelineState to(PipelineState target) {
                throw new IllegalStateException("Invalid transition from FAILED to " + String.valueOf((Object)target));
            }
        };

        private final PipelinePhase phase;

        private PipelineState(PipelinePhase phase) {
            this.phase = Objects.requireNonNull(phase);
        }

        public PipelinePhase getPhase() {
            return this.phase;
        }

        public abstract PipelineState to(PipelineState var1);
    }

    private class WorkerLifecycleListener
    implements TaskManager.LifecycleListener {
        private WorkerLifecycleListener() {
        }

        @Override
        public void onTaskStarted(String task) {
            PipelineManager.this.events.offer(new TaskStartedEvent(task));
        }

        @Override
        public void onTaskWorkerStarted(String task, int worker) {
            PipelineManager.this.events.offer(new WorkerLifecycleEvent(task, worker, listener -> listener.onPipelineTaskWorkerStarted(PipelineManager.this.id, task, worker)));
        }

        @Override
        public void onTaskWorkerStopRequested(String task, int worker) {
            PipelineManager.this.events.offer(new WorkerLifecycleEvent(task, worker, listener -> listener.onPipelineTaskWorkerStopRequested(PipelineManager.this.id, task, worker)));
        }

        @Override
        public void onTaskWorkerStopped(String task, int worker) {
            PipelineManager.this.events.offer(new WorkerLifecycleEvent(task, worker, listener -> listener.onPipelineTaskWorkerStopped(PipelineManager.this.id, task, worker)));
        }

        @Override
        public void onTaskWorkerCompletedNormally(String task, int worker) {
            PipelineManager.this.events.offer(new WorkerLifecycleEvent(task, worker, listener -> listener.onPipelineTaskWorkerCompletedNormally(PipelineManager.this.id, task, worker)));
        }

        @Override
        public void onTaskWorkerCompletedExceptionally(String task, int worker, Throwable cause) {
            PipelineManager.this.events.offer(new WorkerLifecycleEvent(task, worker, listener -> listener.onPipelineTaskWorkerCompletedExceptionally(PipelineManager.this.id, task, worker, cause)));
        }

        @Override
        public void onTaskCancelRequested(String task, int worker) {
            PipelineManager.this.events.offer(new WorkerLifecycleEvent(task, worker, listener -> listener.onPipelineTaskCancelRequested(PipelineManager.this.id, task, worker)));
        }

        @Override
        public void onTaskCompleted(String task) {
            PipelineManager.this.events.offer(new TaskCompletedEvent(task));
        }

        @Override
        public void onTaskCancelled(String task) {
            PipelineManager.this.events.offer(new TaskCancelledEvent(task));
        }

        @Override
        public void onTaskFailed(String task, ExecutionException cause) {
            PipelineManager.this.events.offer(new TaskFailedEvent(task, cause));
        }
    }

    public static enum PipelinePhase {
        READY,
        RUNNING,
        FINISHED;

    }

    static sealed interface PipelineEvent
    permits TaskStartedEvent, TaskCompletedEvent, TaskFailedEvent, TaskCancelledEvent, WorkerLifecycleEvent {
    }

    record TaskStartedEvent(String id) implements PipelineEvent
    {
    }

    record TaskCompletedEvent(String id) implements PipelineEvent
    {
    }

    record TaskFailedEvent(String id, ExecutionException cause) implements PipelineEvent
    {
    }

    record TaskCancelledEvent(String id) implements PipelineEvent
    {
    }

    private record WorkerLifecycleEvent(String taskId, int workerId, Consumer<LifecycleListener> event) implements PipelineEvent
    {
    }

    private class TaskRunner
    implements Runnable {
        private final TaskManager body;

        public TaskRunner(TaskManager body) {
            this.body = Objects.requireNonNull(body);
        }

        @Override
        public void run() {
            try {
                LOGGER.atDebug().addKeyValue("pipeline", (Object)PipelineManager.this.id).addKeyValue("task", (Object)this.body.getId()).log("Pipeline task started");
                this.body.run();
                LOGGER.atDebug().addKeyValue("pipeline", (Object)PipelineManager.this.id).addKeyValue("task", (Object)this.body.getId()).log("Pipeline task completed");
            }
            catch (InterruptedException e) {
                LOGGER.atInfo().addKeyValue("pipeline", (Object)PipelineManager.this.id).addKeyValue("task", (Object)this.body.getId()).log("Pipeline task canceled");
            }
            catch (Throwable t) {
                LOGGER.atError().addKeyValue("pipeline", (Object)PipelineManager.this.id).addKeyValue("task", (Object)this.body.getId()).setCause(t).log("Pipeline task failed");
            }
        }
    }

    public static interface LifecycleListener {
        default public void onPipelineStarted(int pipeline) {
        }

        default public void onPipelineTaskStarted(int pipeline, String task) {
        }

        default public void onPipelineTaskWorkerStarted(int pipeline, String task, int worker) {
        }

        default public void onPipelineTaskWorkerStopRequested(int pipeline, String task, int worker) {
        }

        default public void onPipelineTaskWorkerStopped(int pipeline, String task, int worker) {
        }

        default public void onPipelineTaskWorkerCompletedNormally(int pipeline, String task, int worker) {
        }

        default public void onPipelineTaskWorkerCompletedExceptionally(int pipeline, String task, int worker, Throwable cause) {
        }

        default public void onPipelineTaskCancelRequested(int pipeline, String task, int worker) {
        }

        default public void onPipelineTaskCompleted(int pipeline, String task) {
        }

        default public void onPipelineTaskCancelled(int pipeline, String task) {
        }

        default public void onPipelineTaskFailed(int pipeline, String task, Throwable cause) {
        }

        default public void onPipelineCancelRequested(int pipeline) {
        }

        default public void onPipelineCompleted(int pipeline) {
        }

        default public void onPipelineCancelled(int pipeline) {
        }

        default public void onPipelineFailed(int pipeline, Throwable cause) {
        }
    }

    public record Metrics(int id, PipelinePhase phase, PipelineState state, Map<String, TaskManager.Metrics<?>> tasks) {
        public Metrics {
            Objects.requireNonNull(phase);
            Objects.requireNonNull(state);
            Objects.requireNonNull(tasks);
        }
    }
}

