/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.build;

import io.aleph0.yap.core.build.ConsumerTaskBuilder;
import io.aleph0.yap.core.build.ProcessorTaskBuilder;
import io.aleph0.yap.core.build.TaskBuilder;
import io.aleph0.yap.core.build.TopicBuilder;
import io.aleph0.yap.core.task.DefaultProducerTaskController;
import io.aleph0.yap.core.task.TaskController;
import io.aleph0.yap.core.transport.topic.DefaultTopic;
import io.aleph0.yap.core.worker.ProducerWorkerFactory;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class ProducerTaskBuilder<OutputT, MetricsT>
implements TaskBuilder {
    final String id;
    final ProducerWorkerFactory<OutputT, MetricsT> workerFactory;
    final Set<String> subscribers = new LinkedHashSet<String>();
    TopicBuilder<OutputT> topic = DefaultTopic.builder();
    TaskController.ProducerTaskControllerBuilder<OutputT> controller = DefaultProducerTaskController.builder();

    ProducerTaskBuilder(String id, ProducerWorkerFactory<OutputT, MetricsT> bodyFactory) {
        this.id = Objects.requireNonNull(id);
        this.workerFactory = Objects.requireNonNull(bodyFactory);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ProducerTaskBuilder<OutputT, MetricsT> setTopic(TopicBuilder<OutputT> topic) {
        this.topic = Objects.requireNonNull(topic);
        return this;
    }

    public ProducerTaskBuilder<OutputT, MetricsT> setController(TaskController.ProducerTaskControllerBuilder<OutputT> controller) {
        this.controller = Objects.requireNonNull(controller);
        return this;
    }

    public <NextT> ProducerTaskBuilder<OutputT, MetricsT> addSubscriber(ProcessorTaskBuilder<OutputT, NextT, ?> subscriber) {
        this.subscribers.add(subscriber.getId());
        return this;
    }

    public ProducerTaskBuilder<OutputT, MetricsT> addSubscriber(ConsumerTaskBuilder<OutputT, ?> subscriber) {
        this.subscribers.add(subscriber.getId());
        return this;
    }
}

