/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core;

import io.aleph0.yap.core.Measureable;
import io.aleph0.yap.core.build.PipelineBuilder;
import io.aleph0.yap.core.pipeline.PipelineManager;
import io.aleph0.yap.core.task.TaskManager;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public interface Pipeline
extends Measureable<Metrics> {
    public static PipelineBuilder builder() {
        return new PipelineBuilder();
    }

    public void addLifecycleListener(LifecycleListener var1);

    public void removeLifecycleListener(LifecycleListener var1);

    public int getId();

    public void start();

    public void cancel();

    public void await() throws InterruptedException, ExecutionException, CancellationException;

    public static interface LifecycleListener {
        default public void onPipelineStarted(int pipeline) {
        }

        default public void onPipelineTaskStarted(int pipeline, String task) {
        }

        default public void onPipelineTaskWorkerStarted(int pipeline, String task, int worker) {
        }

        default public void onPipelineTaskWorkerStopRequested(int pipeline, String task, int worker) {
        }

        default public void onPipelineTaskWorkerStopped(int pipeline, String task, int worker) {
        }

        default public void onPipelineTaskWorkerCompletedNormally(int pipeline, String task, int worker) {
        }

        default public void onPipelineTaskWorkerCompletedExceptionally(int pipeline, String task, int worker, Throwable cause) {
        }

        default public void onPipelineTaskCancelRequested(int pipeline, String task, int worker) {
        }

        default public void onPipelineTaskCompleted(int pipeline, String task) {
        }

        default public void onPipelineTaskCancelled(int pipeline, String task) {
        }

        default public void onPipelineTaskFailed(int pipeline, String task, Throwable cause) {
        }

        default public void onPipelineCancelRequested(int pipeline) {
        }

        default public void onPipelineCompleted(int pipeline) {
        }

        default public void onPipelineCancelled(int pipeline) {
        }

        default public void onPipelineFailed(int pipeline, Throwable cause) {
        }
    }

    public record Metrics(int id, PipelineManager.PipelinePhase phase, PipelineManager.PipelineState state, Map<String, TaskManager.Metrics<?>> tasks) {
        public Metrics {
            Objects.requireNonNull(phase);
            Objects.requireNonNull(state);
            Objects.requireNonNull(tasks);
        }
    }
}

