/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.pipeline;

import io.aleph0.yap.core.build.PipelineControllerBuilder;
import io.aleph0.yap.core.pipeline.PipelineController;
import io.aleph0.yap.core.pipeline.action.PipelineAction;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPipelineController
implements PipelineController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPipelineController.class);
    private final Set<String> running = new LinkedHashSet<String>();
    private final Set<String> starting = new LinkedHashSet<String>();
    PipelineState state = PipelineState.READY;
    private final Map<String, Set<String>> subscribers;
    private final Map<String, Set<String>> publishers;
    private final Duration heartbeatInterval;
    private ExecutionException failureReason;

    public static Builder builder() {
        return new Builder();
    }

    public DefaultPipelineController(Map<String, Set<String>> graph, Duration heartbeatInterval) {
        this.subscribers = graph.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableSet((Set)e.getValue())));
        this.publishers = graph.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(subscriber -> Map.entry(subscriber, (String)e.getKey()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
        this.heartbeatInterval = heartbeatInterval;
    }

    @Override
    public List<PipelineAction> onPipelineStarted() {
        ArrayList<PipelineAction> result = new ArrayList<PipelineAction>();
        switch (this.state) {
            case READY: {
                this.state = this.state.to(PipelineState.RUNNING);
                for (Map.Entry<String, Set<String>> entry : this.subscribers.entrySet()) {
                    String taskId = entry.getKey();
                    Set<String> taskSubscribers = entry.getValue();
                    if (!this.running.containsAll(taskSubscribers) || this.running.contains(taskId) || this.starting.contains(taskId)) continue;
                    result.add(PipelineAction.startTask(taskId));
                    this.starting.add(taskId);
                }
                break;
            }
            default: {
                throw new IllegalStateException("pipeline in state " + String.valueOf((Object)this.state));
            }
        }
        return result;
    }

    @Override
    public List<PipelineAction> onTaskStarted(String id) {
        boolean removed = this.starting.remove(id);
        if (!removed) {
            LOGGER.atWarn().addKeyValue("task", (Object)id).log("Task started, but there was no start request");
        }
        this.running.add(id);
        ArrayList<PipelineAction> result = new ArrayList<PipelineAction>();
        for (Map.Entry<String, Set<String>> entry : this.subscribers.entrySet()) {
            String taskId = entry.getKey();
            Set<String> taskSubscribers = entry.getValue();
            if (!this.running.containsAll(taskSubscribers) || this.running.contains(taskId) || this.starting.contains(taskId)) continue;
            result.add(PipelineAction.startTask(taskId));
            this.starting.add(taskId);
        }
        return result;
    }

    @Override
    public List<PipelineAction> onTaskCompleted(String id) {
        this.running.remove(id);
        ArrayList<PipelineAction> result = new ArrayList<PipelineAction>();
        switch (this.state) {
            case RUNNING: {
                for (Map.Entry<String, Set<String>> entry : this.subscribers.entrySet()) {
                    String taskId = entry.getKey();
                    Set<String> taskSubscribers = entry.getValue();
                    if (!this.running.contains(taskId) || this.running.containsAll(taskSubscribers)) continue;
                    this.state = this.state.to(PipelineState.FAILING);
                    this.failureReason = new ExecutionException(new IllegalStateException("Task " + id + " completed, but not all subscribers are done"));
                    break;
                }
                if (this.state == PipelineState.FAILING) {
                    for (String taskId : this.running) {
                        result.add(PipelineAction.cancelTask(taskId));
                    }
                    break;
                }
                if (!this.running.isEmpty()) break;
                this.state = this.state.to(PipelineState.COMPLETED);
                result.add(PipelineAction.succeed());
                break;
            }
            case CANCELING: {
                if (!this.running.isEmpty()) break;
                this.state = this.state.to(PipelineState.CANCELED);
                return List.of(PipelineAction.cancel());
            }
            case FAILING: {
                if (!this.running.isEmpty()) break;
                this.state = this.state.to(PipelineState.FAILED);
                return List.of(PipelineAction.fail(this.failureReason));
            }
            default: {
                throw new IllegalStateException("pipeline in state " + String.valueOf((Object)this.state));
            }
        }
        return result;
    }

    @Override
    public List<PipelineAction> onTaskCancelled(String id) {
        this.running.remove(id);
        ArrayList<PipelineAction> result = new ArrayList<PipelineAction>();
        switch (this.state) {
            case RUNNING: {
                LOGGER.atWarn().addKeyValue("task", (Object)id).log("Task canceled, but there was no cancellation request. Failing pipeline...");
                this.state = this.state.to(PipelineState.FAILING);
                this.failureReason = new ExecutionException(new IllegalStateException("Task " + id + " canceled, but no cancellation was requested"));
                if (this.running.isEmpty()) {
                    this.state = this.state.to(PipelineState.FAILED);
                    result.add(PipelineAction.fail(this.failureReason));
                    break;
                }
                for (String taskId : this.running) {
                    result.add(PipelineAction.cancelTask(taskId));
                }
                break;
            }
            case CANCELING: {
                if (!this.running.isEmpty()) break;
                this.state = this.state.to(PipelineState.CANCELED);
                return List.of(PipelineAction.cancel());
            }
            case FAILING: {
                if (!this.running.isEmpty()) break;
                this.state = this.state.to(PipelineState.FAILED);
                return List.of(PipelineAction.fail(this.failureReason));
            }
            default: {
                throw new IllegalStateException("pipeline in state " + String.valueOf((Object)this.state));
            }
        }
        return result;
    }

    @Override
    public List<PipelineAction> onTaskFailed(String id, Throwable error) {
        this.running.remove(id);
        while (error instanceof ExecutionException) {
            error = error.getCause();
        }
        if (this.failureReason == null) {
            this.failureReason = new ExecutionException(error);
        } else {
            this.failureReason.addSuppressed(error);
        }
        ArrayList<PipelineAction> result = new ArrayList<PipelineAction>();
        switch (this.state) {
            case RUNNING: 
            case CANCELING: {
                this.state = this.state.to(PipelineState.FAILING);
                for (String taskId : this.running) {
                    result.add(PipelineAction.cancelTask(taskId));
                }
            }
            case FAILING: {
                if (!this.running.isEmpty()) break;
                this.state = this.state.to(PipelineState.FAILED);
                return List.of(PipelineAction.fail(this.failureReason));
            }
            default: {
                throw new IllegalStateException("pipeline in state " + String.valueOf((Object)this.state));
            }
        }
        return result;
    }

    @Override
    public List<PipelineAction> onHeartbeat() {
        return List.of();
    }

    @Override
    public List<PipelineAction> onCancelRequested() {
        ArrayList<PipelineAction> result = new ArrayList<PipelineAction>();
        switch (this.state) {
            case RUNNING: {
                this.state = this.state.to(PipelineState.CANCELING);
                for (String taskId : this.running) {
                    result.add(PipelineAction.cancelTask(taskId));
                }
                break;
            }
            case CANCELING: {
                break;
            }
            case FAILING: {
                break;
            }
            default: {
                throw new IllegalStateException("pipeline in state " + String.valueOf((Object)this.state));
            }
        }
        return result;
    }

    @Override
    public void onPipelineCompleted() {
    }

    @Override
    public void onPipelineFailed(ExecutionException error) {
    }

    @Override
    public void onPipelineCancelled() {
    }

    @Override
    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public static class Builder
    implements PipelineControllerBuilder {
        private Duration heartbeatInterval = Duration.ofMinutes(1L);

        public Builder setHeartbeatInterval(Duration heartbeatInterval) {
            if (heartbeatInterval == null) {
                throw new NullPointerException();
            }
            if (heartbeatInterval.isNegative() || heartbeatInterval.isZero()) {
                throw new IllegalArgumentException("heartbeatInterval must be positive");
            }
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        @Override
        public DefaultPipelineController build(Map<String, Set<String>> graph) {
            return new DefaultPipelineController(graph, this.heartbeatInterval);
        }
    }

    public static enum PipelineState {
        READY{

            @Override
            public PipelineState to(PipelineState target) {
                if (target == RUNNING) {
                    return target;
                }
                throw new IllegalStateException("cannot transition from READY to " + String.valueOf((Object)target));
            }
        }
        ,
        RUNNING{

            @Override
            public PipelineState to(PipelineState target) {
                if (target == COMPLETED || target == CANCELING || target == FAILING || target == FAILED) {
                    return target;
                }
                throw new IllegalStateException("cannot transition from RUNNING to " + String.valueOf((Object)target));
            }
        }
        ,
        CANCELING{

            @Override
            public PipelineState to(PipelineState target) {
                if (target == CANCELED || target == FAILING || target == FAILED) {
                    return target;
                }
                throw new IllegalStateException("cannot transition from CANCELING to " + String.valueOf((Object)target));
            }
        }
        ,
        FAILING{

            @Override
            public PipelineState to(PipelineState target) {
                if (target == FAILED) {
                    return target;
                }
                throw new IllegalStateException("cannot transition from FAILING to " + String.valueOf((Object)target));
            }
        }
        ,
        COMPLETED{

            @Override
            public PipelineState to(PipelineState target) {
                throw new IllegalStateException("cannot transition from COMPLETED to " + String.valueOf((Object)target));
            }
        }
        ,
        CANCELED{

            @Override
            public PipelineState to(PipelineState target) {
                throw new IllegalStateException("cannot transition from CANCELED to " + String.valueOf((Object)target));
            }
        }
        ,
        FAILED{

            @Override
            public PipelineState to(PipelineState target) {
                throw new IllegalStateException("cannot transition from FAILED to " + String.valueOf((Object)target));
            }
        };


        public abstract PipelineState to(PipelineState var1);
    }
}

