/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.pipeline;

import io.aleph0.yap.core.Pipeline;
import io.aleph0.yap.core.pipeline.PipelineManager;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class DefaultPipeline
implements Pipeline {
    private final List<Pipeline.LifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<Pipeline.LifecycleListener>();
    private final PipelineManager manager;
    private volatile boolean cancelled = false;
    private volatile Future<?> future;

    public DefaultPipeline(PipelineManager manager) {
        this.manager = Objects.requireNonNull(manager);
        this.manager.addLifecycleListener(new PipelineManagerLifecycleListenerAdapter());
    }

    @Override
    public void addLifecycleListener(Pipeline.LifecycleListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.lifecycleListeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(Pipeline.LifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
    }

    @Override
    public int getId() {
        return this.manager.getId();
    }

    @Override
    public void start() {
        if (this.cancelled) {
            return;
        }
        if (this.future != null) {
            return;
        }
        this.future = Executors.newVirtualThreadPerTaskExecutor().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DefaultPipeline.this.manager.run();
                return null;
            }
        });
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    @Override
    public void await() throws InterruptedException, ExecutionException, CancellationException {
        if (this.cancelled && this.future == null) {
            throw new CancellationException();
        }
        this.future.get();
    }

    @Override
    public Pipeline.Metrics checkMetrics() {
        PipelineManager.Metrics metrics = this.manager.checkMetrics();
        return new Pipeline.Metrics(metrics.id(), metrics.phase(), metrics.state(), metrics.tasks());
    }

    @Override
    public Pipeline.Metrics flushMetrics() {
        Pipeline.Metrics result = this.checkMetrics();
        this.manager.flushMetrics();
        return result;
    }

    private void notifyLifecycleListeners(Consumer<Pipeline.LifecycleListener> event) {
        for (Pipeline.LifecycleListener listener : this.lifecycleListeners) {
            event.accept(listener);
        }
    }

    private class PipelineManagerLifecycleListenerAdapter
    implements PipelineManager.LifecycleListener {
        private PipelineManagerLifecycleListenerAdapter() {
        }

        @Override
        public void onPipelineStarted(int pipeline) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineStarted(pipeline));
        }

        @Override
        public void onPipelineTaskStarted(int pipeline, String task) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineTaskStarted(pipeline, task));
        }

        @Override
        public void onPipelineTaskWorkerStarted(int pipeline, String task, int worker) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineTaskWorkerStarted(pipeline, task, worker));
        }

        @Override
        public void onPipelineTaskWorkerStopRequested(int pipeline, String task, int worker) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineTaskWorkerStopRequested(pipeline, task, worker));
        }

        @Override
        public void onPipelineTaskWorkerStopped(int pipeline, String task, int worker) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineTaskWorkerStopped(pipeline, task, worker));
        }

        @Override
        public void onPipelineTaskWorkerCompletedNormally(int pipeline, String task, int worker) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineTaskWorkerCompletedNormally(pipeline, task, worker));
        }

        @Override
        public void onPipelineTaskWorkerCompletedExceptionally(int pipeline, String task, int worker, Throwable cause) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineTaskWorkerCompletedExceptionally(pipeline, task, worker, cause));
        }

        @Override
        public void onPipelineTaskCancelRequested(int pipeline, String task, int worker) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineTaskCancelRequested(pipeline, task, worker));
        }

        @Override
        public void onPipelineTaskCompleted(int pipeline, String task) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineTaskCompleted(pipeline, task));
        }

        @Override
        public void onPipelineTaskCancelled(int pipeline, String task) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineTaskCancelled(pipeline, task));
        }

        @Override
        public void onPipelineTaskFailed(int pipeline, String task, Throwable cause) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineTaskFailed(pipeline, task, cause));
        }

        @Override
        public void onPipelineCancelRequested(int pipeline) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineCancelRequested(pipeline));
        }

        @Override
        public void onPipelineCompleted(int pipeline) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineCompleted(pipeline));
        }

        @Override
        public void onPipelineCancelled(int pipeline) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineCancelled(pipeline));
        }

        @Override
        public void onPipelineFailed(int pipeline, Throwable cause) {
            DefaultPipeline.this.notifyLifecycleListeners(l -> l.onPipelineFailed(pipeline, cause));
        }
    }
}

