/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class DirectedGraphs {
    private DirectedGraphs() {
    }

    public static boolean isWeaklyConnected(Map<String, Set<String>> graph) {
        HashSet<String> visited = new HashSet<String>();
        ArrayDeque<String> queue = new ArrayDeque<String>();
        String startNode = graph.keySet().iterator().next();
        queue.add(startNode);
        visited.add(startNode);
        while (!queue.isEmpty()) {
            String node = (String)queue.poll();
            for (String string : graph.getOrDefault(node, Set.of())) {
                if (visited.contains(string)) continue;
                visited.add(string);
                queue.add(string);
            }
            for (Map.Entry entry : graph.entrySet()) {
                if (!((Set)entry.getValue()).contains(node) || visited.contains(entry.getKey())) continue;
                visited.add((String)entry.getKey());
                queue.add((String)entry.getKey());
            }
        }
        return visited.size() == graph.size();
    }

    public static Optional<List<String>> findCycle(Map<String, Set<String>> graph) {
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> stack = new HashSet<String>();
        ArrayList<String> cycle = new ArrayList<String>();
        for (String node : graph.keySet()) {
            if (!DirectedGraphs.findCycleUtil(graph, node, visited, stack, cycle)) continue;
            return Optional.of(cycle);
        }
        return Optional.empty();
    }

    private static boolean findCycleUtil(Map<String, Set<String>> graph, String node, Set<String> visited, Set<String> stack, List<String> cycle) {
        if (stack.contains(node)) {
            cycle.add(node);
            return true;
        }
        if (visited.contains(node)) {
            return false;
        }
        visited.add(node);
        stack.add(node);
        for (String neighbor : graph.getOrDefault(node, Set.of())) {
            if (!DirectedGraphs.findCycleUtil(graph, neighbor, visited, stack, cycle)) continue;
            if (!cycle.contains(node)) {
                cycle.add(node);
            }
            return true;
        }
        stack.remove(node);
        return false;
    }
}

