/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.benchs.transform;

import io.aiven.kafka.tieredstorage.benchs.AesKeyAware;
import io.aiven.kafka.tieredstorage.manifest.index.ChunkIndex;
import io.aiven.kafka.tieredstorage.transform.BaseDetransformChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.BaseTransformChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.CompressionChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.DecompressionChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.DecryptionChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.DetransformChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.DetransformFinisher;
import io.aiven.kafka.tieredstorage.transform.EncryptionChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.TransformChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.TransformFinisher;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.AsyncProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=4)
@Measurement(iterations=16)
@BenchmarkMode(value={Mode.Throughput, Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class DetransformBench
extends AesKeyAware {
    static Path segmentPath;
    @Param(value={"10485760", "104857600", "1073741824"})
    public int contentLength;
    @Param(value={"102400", "1048576", "5242880"})
    public int chunkSize;
    @Param(value={"false", "true"})
    public boolean compression;
    @Param(value={"false", "true"})
    public boolean encryption;
    byte[] uploadedData;
    ChunkIndex chunkIndex;

    @Setup(value=Level.Trial)
    public void setup() throws IOException {
        segmentPath = Files.createTempFile("segment", ".log", new FileAttribute[0]);
        SecureRandom secureRandom = new SecureRandom();
        try (OutputStream out = Files.newOutputStream(segmentPath, new OpenOption[0]);){
            byte[] bytes = new byte[this.contentLength];
            secureRandom.nextBytes(bytes);
            out.write(bytes);
        }
        if (this.encryption) {
            DetransformBench.initCrypto();
        }
        BaseTransformChunkEnumeration transformEnum = new BaseTransformChunkEnumeration(Files.newInputStream(segmentPath, new OpenOption[0]), this.chunkSize);
        if (this.compression) {
            transformEnum = new CompressionChunkEnumeration((TransformChunkEnumeration)transformEnum);
        }
        if (this.encryption) {
            transformEnum = new EncryptionChunkEnumeration((TransformChunkEnumeration)transformEnum, () -> AesKeyAware.encryptionCipherSupplier());
        }
        TransformFinisher transformFinisher = TransformFinisher.newBuilder((TransformChunkEnumeration)transformEnum, (int)this.contentLength).build();
        try (SequenceInputStream sis = new SequenceInputStream((Enumeration<? extends InputStream>)transformFinisher);){
            this.uploadedData = sis.readAllBytes();
            this.chunkIndex = transformFinisher.chunkIndex();
        }
    }

    @TearDown
    public void teardown() throws IOException {
        Files.deleteIfExists(segmentPath);
    }

    @Benchmark
    public int test() throws IOException {
        BaseDetransformChunkEnumeration detransformEnum = new BaseDetransformChunkEnumeration((InputStream)new ByteArrayInputStream(this.uploadedData), this.chunkIndex.chunks());
        if (this.encryption) {
            detransformEnum = new DecryptionChunkEnumeration((DetransformChunkEnumeration)detransformEnum, ivSize, x$0 -> AesKeyAware.decryptionCipherSupplier(x$0));
        }
        if (this.compression) {
            detransformEnum = new DecompressionChunkEnumeration((DetransformChunkEnumeration)detransformEnum);
        }
        DetransformFinisher detransformFinisher = new DetransformFinisher((DetransformChunkEnumeration)detransformEnum);
        try (SequenceInputStream sis = new SequenceInputStream((Enumeration<? extends InputStream>)detransformFinisher);){
            byte[] bytes = sis.readAllBytes();
            int n = bytes.length;
            return n;
        }
    }

    public static void main(String[] args) throws Exception {
        Options opts = new OptionsBuilder().include(DetransformBench.class.getSimpleName()).addProfiler(AsyncProfiler.class, "output=flamegraph").build();
        new Runner(opts).run();
    }
}

