/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.benchs;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesKeyAware {
    protected static int ivSize;
    protected static SecretKeySpec secretKey;
    protected static byte[] aad;

    public static void initCrypto() {
        Random random = new Random();
        byte[] dataKey = new byte[32];
        random.nextBytes(dataKey);
        secretKey = new SecretKeySpec(dataKey, "AES");
        aad = new byte[32];
        random.nextBytes(aad);
        ivSize = AesKeyAware.encryptionCipherSupplier().getIV().length;
    }

    protected static Cipher encryptionCipherSupplier() {
        try {
            Cipher encryptCipher = AesKeyAware.getCipher();
            encryptCipher.init(1, (Key)secretKey, SecureRandom.getInstanceStrong());
            encryptCipher.updateAAD(aad);
            return encryptCipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Cipher decryptionCipherSupplier(byte[] encryptedChunk) {
        try {
            Cipher encryptCipher = AesKeyAware.getCipher();
            encryptCipher.init(2, (Key)secretKey, new GCMParameterSpec(128, encryptedChunk, 0, ivSize), SecureRandom.getInstanceStrong());
            encryptCipher.updateAAD(aad);
            return encryptCipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Cipher getCipher() {
        try {
            return Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }
}

