/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.benchmarks.CurrentTimeMillisTimerBench;
import org.openjdk.jmh.benchmarks.EmptyBench;
import org.openjdk.jmh.benchmarks.NanoTimerBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;

public class TimingMeasurementsTest
extends ValidationTest {
    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- TIMING MEASUREMENTS TEST");
        pw.println();
        Utils.reflow(pw, "This test shows the minimal individual timings possible to measure. This normally affects only SampleTime and SingleShot benchmark modes. Throughput/AverageTime tests can do better since they do only a few timestamps before and after the complete iteration.", 80, 2);
        pw.println();
        this.doNanoTime(pw, parent, "latency", false);
        this.doNanoTime(pw, parent, "latency", true);
        pw.println();
        this.doCurrentTimeMillis(pw, parent, "latency", false);
        this.doCurrentTimeMillis(pw, parent, "latency", true);
        pw.println();
        this.doNanoTime(pw, parent, "granularity", false);
        this.doNanoTime(pw, parent, "granularity", true);
        pw.println();
        this.doCurrentTimeMillis(pw, parent, "granularity", false);
        this.doCurrentTimeMillis(pw, parent, "granularity", true);
        pw.println();
        for (Mode mode : Mode.values()) {
            if (mode == Mode.All) continue;
            this.doEmpty(pw, parent, mode, false);
        }
        pw.println();
        for (Mode mode : Mode.values()) {
            if (mode == Mode.All) continue;
            this.doEmpty(pw, parent, mode, true);
        }
        pw.println();
    }

    private void doEmpty(PrintWriter pw, Options parent, Mode mode, boolean max) throws RunnerException {
        Options opts = new OptionsBuilder().parent(parent).include(EmptyBench.class.getCanonicalName()).verbosity(VerboseMode.SILENT).threads(max ? -1 : 1).mode(mode).build();
        RunResult result = new Runner(opts).runSingle();
        Result r = result.getPrimaryResult();
        pw.printf("%50s", (Object)((Object)mode) + ", empty benchmark, " + (max ? "max thread" : "one thread") + ": ");
        pw.flush();
        pw.printf("%10.2f \u00b1 %10.2f %s\n", r.getScore(), r.getScoreError(), r.getScoreUnit());
    }

    void doNanoTime(PrintWriter pw, Options parent, String type, boolean max) throws RunnerException {
        Options opts = new OptionsBuilder().parent(parent).include(NanoTimerBench.class.getCanonicalName() + "." + type + "$").verbosity(VerboseMode.SILENT).threads(max ? -1 : 1).build();
        RunResult result = new Runner(opts).runSingle();
        Result r = result.getPrimaryResult();
        pw.printf("%50s", "nanoTime() " + type + ", " + (max ? "max thread" : "one thread") + ": ");
        pw.flush();
        pw.printf("%10.2f \u00b1 %10.2f ns\n", r.getScore(), r.getScoreError());
    }

    void doCurrentTimeMillis(PrintWriter pw, Options parent, String type, boolean max) throws RunnerException {
        Options opts = new OptionsBuilder().parent(parent).include(CurrentTimeMillisTimerBench.class.getCanonicalName() + "." + type + "$").verbosity(VerboseMode.SILENT).threads(max ? -1 : 1).build();
        RunResult result = new Runner(opts).runSingle();
        Result r = result.getPrimaryResult();
        pw.printf("%50s", "currentTimeMillis() " + type + ", " + (max ? "max thread" : "one thread") + ": ");
        pw.flush();
        pw.printf("%10.2f \u00b1 %10.2f ns\n", r.getScore(), r.getScoreError());
    }
}

