/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import org.openjdk.jmh.benchmarks.ThermalRundownBench;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.IterationScoresFormatter;
import org.openjdk.jmh.validation.ValidationTest;

public class ThermalRundownTest
extends ValidationTest {
    private final int iterations;

    public ThermalRundownTest(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- THERMAL RUNDOWN TEST");
        pw.println();
        Utils.reflow(pw, "This test tries to heat the machine up, trying to kick in the thermal throttling. If you see the diminishing performance over time, then your system throttles, and many benchmark experiments are unreliable. ", 80, 2);
        pw.println();
        Options opts = new OptionsBuilder().parent(parent).include(ThermalRundownBench.class.getCanonicalName()).warmupIterations(0).measurementIterations(this.iterations).measurementTime(TimeValue.seconds(10L)).threads(-1).forks(1).verbosity(VerboseMode.SILENT).build();
        new Runner(opts, new IterationScoresFormatter(pw)).runSingle();
        pw.println();
    }
}

