/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import org.openjdk.jmh.benchmarks.RoundTripLatencyBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.AffinitySupport;
import org.openjdk.jmh.validation.SpinWaitSupport;
import org.openjdk.jmh.validation.ValidationTest;

public class RoundTripLatencyTest
extends ValidationTest {
    private boolean spinWaitHints;

    public RoundTripLatencyTest(boolean spinWaitHints) {
        this.spinWaitHints = spinWaitHints;
    }

    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- ROUND-TRIP LATENCY TEST" + (this.spinWaitHints ? " (SPIN-WAIT HINTS)" : ""));
        pw.println();
        Utils.reflow(pw, "This test tries to run latency benchmark across the entire system. For many-core systems, it is normal to see large latency variations between CPU threads pairs. This gives the idea how much the tests with communicating threads would differ when scheduled differently.", 80, 2);
        pw.println();
        pw.println("  Scores are nanoseconds per round-trip.");
        pw.println("  Axes are CPU numbers as presented by OS.");
        pw.println();
        if (!AffinitySupport.isSupported()) {
            pw.println("  Affinity control is not available on this machine, skipping the test.");
            pw.println();
            return;
        }
        if (this.spinWaitHints && !SpinWaitSupport.available()) {
            pw.println("  Spin-wait hints are not supported, skipping the test.");
            pw.println();
            return;
        }
        Options basic = new OptionsBuilder().parent(parent).include(RoundTripLatencyBench.class.getCanonicalName()).threads(1).jvmArgsAppend("-Xms512m", "-Xmx512m", "-XX:+AlwaysPreTouch", "-XX:+UseParallelGC", "-XX:+UseNUMA", "-DspinWait=" + this.spinWaitHints).verbosity(VerboseMode.SILENT).build();
        int blockSize = 16;
        int threads = Utils.figureOutHotCPUs();
        int blocks = threads / blockSize;
        if (blocks * blockSize < threads) {
            ++blocks;
        }
        for (int pBlock = 0; pBlock < blocks; ++pBlock) {
            int fromP = pBlock * blockSize;
            int toP = Math.min(threads, (pBlock + 1) * blockSize);
            for (int cBlock = 0; cBlock < blocks; ++cBlock) {
                int fromC = cBlock * blockSize;
                int toC = Math.min(threads, (cBlock + 1) * blockSize);
                pw.printf("%5s  ", "");
                for (int c = fromC; c < toC; ++c) {
                    pw.printf("%5d:", c);
                }
                pw.println();
                for (int p = fromP; p < toP; ++p) {
                    pw.printf("%5d: ", p);
                    for (int c = fromC; c < toC; ++c) {
                        if (p == c) {
                            pw.print(" ----,");
                            continue;
                        }
                        Options opts = new OptionsBuilder().parent(basic).param("p", String.valueOf(p)).param("c", String.valueOf(c)).build();
                        Result r = new Runner(opts).runSingle().getPrimaryResult();
                        pw.print(String.format("%5.0f,", r.getScore()));
                        pw.flush();
                    }
                    pw.println();
                }
                pw.println();
            }
        }
    }
}

