/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jmh.benchmarks.LongStabilityBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;

public class LongStabilityTest
extends ValidationTest {
    private final int tries;

    public LongStabilityTest(int tries) {
        this.tries = tries;
    }

    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- LONG STABILITY TEST");
        pw.println();
        Utils.reflow(pw, "This test verifies the performance for a single test by running it several times with some delays between the runs. The performance should be the same across all runs. If there is a significant difference between the runs, this is usually indicative of noisy environment, e.g. a busy virtualized node, or background processes interfering with the run, making the benchmarks unreliable.", 80, 2);
        pw.println();
        for (int t = 0; t < this.tries; ++t) {
            int ms = t == 0 ? 0 : ThreadLocalRandom.current().nextInt(5000, 30000);
            pw.printf("  Sleeping for %6d ms...", ms);
            pw.flush();
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            pw.print("  Run: ");
            pw.flush();
            Options opts = new OptionsBuilder().parent(parent).include(LongStabilityBench.class.getCanonicalName()).warmupIterations(5).warmupTime(TimeValue.seconds(1L)).measurementIterations(5).measurementTime(TimeValue.seconds(1L)).forks(1).verbosity(VerboseMode.SILENT).build();
            RunResult result = new Runner(opts).runSingle();
            Result r = result.getPrimaryResult();
            pw.printf(" %16s", String.format("%.2f \u00b1 %.2f %s%n", r.getScore(), r.getScoreError(), r.getScoreUnit()));
            pw.flush();
        }
    }
}

