/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import org.openjdk.jmh.benchmarks.CoreStabilityBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.AffinitySupport;
import org.openjdk.jmh.validation.ValidationTest;

public class CoreStabilityTest
extends ValidationTest {
    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- CORE STABILITY TEST");
        pw.println();
        Utils.reflow(pw, "This test verifies the performance for a single test by running it on different CPUs. For perfectly symmetric machines, the performance should be the same across all CPUs. If there is a significant difference between the CPUs, this is usually indicative of asymmetric machine, making the benchmarks that do not explicitly control affinity less reliable.", 80, 2);
        pw.println();
        if (!AffinitySupport.isSupported()) {
            pw.println("  Affinity control is not available on this machine, skipping the test.");
            pw.println();
            return;
        }
        int threads = Utils.figureOutHotCPUs();
        for (int p = 0; p < threads; ++p) {
            pw.printf("  CPU %3d: ", p);
            pw.flush();
            Options opts = new OptionsBuilder().parent(parent).include(CoreStabilityBench.class.getCanonicalName()).param("p", String.valueOf(p)).verbosity(VerboseMode.SILENT).build();
            RunResult result = new Runner(opts).runSingle();
            Result r = result.getPrimaryResult();
            pw.printf(" %16s", String.format("%.2f \u00b1 %.2f %s%n", r.getScore(), r.getScoreError(), r.getScoreUnit()));
            pw.flush();
        }
    }
}

