/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.benchmarks.CompilerHintsBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;

public class CompilerHintsTest
extends ValidationTest {
    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- COMPILER HINTS TEST");
        pw.println();
        Utils.reflow(pw, "This tests verifies compiler hints are working as expected. Two baseline tests run the workload in inlined and non-inlined regiments. When the workload is inlined, the optimizations should kill the workload body. Compiler hints should successfully survive in both regiments: " + (Object)((Object)CompilerControl.Mode.INLINE) + " should always inline, and " + (Object)((Object)CompilerControl.Mode.DONT_INLINE) + " should always break inlining. " + (Object)((Object)CompilerControl.Mode.EXCLUDE) + " should be neutral to inlining policy completely.", 80, 2);
        pw.println();
        this.doWith(parent, pw, "baseI_baseline", "Default inline policy");
        this.doWith(parent, pw, "baseI_inline", "  + @" + CompilerControl.class.getSimpleName() + "(" + (Object)((Object)CompilerControl.Mode.INLINE) + ")");
        this.doWith(parent, pw, "baseI_dontInline", "  + @" + CompilerControl.class.getSimpleName() + "(" + (Object)((Object)CompilerControl.Mode.DONT_INLINE) + ")");
        this.doWith(parent, pw, "baseI_exclude", "  + @" + CompilerControl.class.getSimpleName() + "(" + (Object)((Object)CompilerControl.Mode.EXCLUDE) + ")");
        pw.println();
        this.doWith(parent, pw, "baseNI_baseline", "Default no inline policy");
        this.doWith(parent, pw, "baseNI_inline", "  + @" + CompilerControl.class.getSimpleName() + "(" + (Object)((Object)CompilerControl.Mode.INLINE) + ")");
        this.doWith(parent, pw, "baseNI_dontInline", "  + @" + CompilerControl.class.getSimpleName() + "(" + (Object)((Object)CompilerControl.Mode.DONT_INLINE) + ")");
        this.doWith(parent, pw, "baseNI_exclude", "  + @" + CompilerControl.class.getSimpleName() + "(" + (Object)((Object)CompilerControl.Mode.EXCLUDE) + ")");
        pw.println();
    }

    private void doWith(Options parent, PrintWriter pw, String test, String descr) throws RunnerException {
        Options opts = new OptionsBuilder().parent(parent).include(CompilerHintsBench.class.getCanonicalName() + "." + test + "$").verbosity(VerboseMode.SILENT).build();
        RunResult result = new Runner(opts).runSingle();
        Result r = result.getPrimaryResult();
        pw.printf("%50s", descr + ": ");
        pw.flush();
        pw.printf("%.2f \u00b1 %.2f ns\n", r.getScore(), r.getScoreError());
    }
}

