/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.benchmarks.BurstStabilityBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;

public class BurstStabilityTest
extends ValidationTest {
    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- BURST STABILITY TEST");
        pw.println();
        Utils.reflow(pw, "This test verifies the performance for a large busy benchmark is the same, regardless of the benchmark mode, and delay before the iteration. The performance should be the same across all delay values, and comparable across different benchmark modes. If there is a significant difference on different delay levels, this is usually indicative of power-saving features enabled, making bursty benchmarks unreliable.", 80, 2);
        pw.println();
        pw.println("  Scores are milliseconds per benchmark operation, or the reciprocal to it.");
        pw.println("  Delays are injected before each iteration, and are measured in milliseconds.");
        pw.println();
        int[] delays = new int[]{0, 1, 10, 100, 1000};
        pw.printf("%20s", "");
        for (int delay : delays) {
            pw.printf("%16s", delay);
        }
        pw.println();
        for (Mode m : Mode.values()) {
            if (m == Mode.All) continue;
            Result r = null;
            pw.printf("%20s", (Object)((Object)m) + ": ");
            for (int delay : delays) {
                Options opts = new OptionsBuilder().parent(parent).mode(m).include(BurstStabilityBench.class.getCanonicalName()).verbosity(VerboseMode.SILENT).param("delay", String.valueOf(delay)).build();
                RunResult result = new Runner(opts).runSingle();
                r = result.getPrimaryResult();
                pw.printf("%16s", String.format("%.2f \u00b1 %.2f", r.getScore(), r.getScoreError()));
                pw.flush();
            }
            pw.println("   " + r.getScoreUnit());
        }
        pw.println();
    }
}

