/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import org.openjdk.jmh.benchmarks.BlackholeBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;
import org.openjdk.jmh.validation.tests.BlackholeTestMode;

public class BlackholeSingleTest
extends ValidationTest {
    private final BlackholeTestMode mode;

    public BlackholeSingleTest(BlackholeTestMode mode) {
        this.mode = mode;
    }

    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- BLACKHOLE SINGLE INVOCATION TEST (" + this.blackholeModeString(this.mode) + ")");
        pw.println();
        Utils.reflow(pw, "This test shows the Blackhole overheads, when using a single invocation in the method, whether implicitly via return from @Benchmark, or explicitly via consume(). The performance should be the same for implicit and explicit cases, and comparable across all data types. ", 80, 2);
        pw.println();
        this.blackholeModeMessage(pw, this.mode);
        String[] types = new String[]{"boolean", "byte", "short", "char", "int", "float", "long", "double", "Object", "Array"};
        String[] modes = new String[]{"implicit", "explicit"};
        pw.println("  Scores are nanoseconds per benchmark op.");
        pw.println();
        pw.printf("%20s", "");
        for (String mode : modes) {
            pw.printf("%20s", mode);
        }
        pw.println();
        for (String type : types) {
            pw.printf("%20s", type + ": ");
            for (String impl : modes) {
                Options opts = new OptionsBuilder().parent(parent).include(BlackholeBench.class.getCanonicalName() + "." + impl + "_" + type).verbosity(VerboseMode.SILENT).build();
                RunResult result = new Runner(opts).runSingle();
                Result r = result.getPrimaryResult();
                pw.flush();
                pw.printf("%20s", String.format("%.2f \u00b1 %.2f ns", r.getScore(), r.getScoreError()));
            }
            pw.println();
        }
        pw.println();
    }
}

