/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import java.util.Arrays;
import org.openjdk.jmh.benchmarks.BlackholePipelineBench;
import org.openjdk.jmh.benchmarks.BlackholePipelinePayloadBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;
import org.openjdk.jmh.validation.tests.BlackholeTestMode;

public class BlackholePipelinedTest
extends ValidationTest {
    private final boolean payload;
    private final BlackholeTestMode mode;

    public BlackholePipelinedTest(boolean payload, BlackholeTestMode mode) {
        this.payload = payload;
        this.mode = mode;
    }

    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- BLACKHOLE PIPELINED TEST" + (this.payload ? " + REAL PAYLOAD" : "") + " (" + this.blackholeModeString(this.mode) + ")");
        pw.println();
        Utils.reflow(pw, "This test shows the Blackhole performance in a loop with a given number of iterations. We should normally see the uniform numbers across most data types and number of iterations. If the numbers are wildly non-uniform across the number of iteration, this is indicative of Blackhole failure, and may point to a serious JMH issue. Scores are nanoseconds per loop iteration.", 80, 2);
        pw.println();
        if (this.payload) {
            pw.println("  Real payload is being injected into the benchmark.");
            pw.println();
        }
        this.blackholeModeMessage(pw, this.mode);
        String[] types = new String[]{"boolean", "byte", "short", "char", "int", "float", "long", "double", "Object", "Array"};
        int[] ss = new int[]{1, 10, 100, 1000, 10000};
        pw.println("  Scores are nanoseconds per (normalized) benchmark op.");
        pw.println("  Trying loops with " + Arrays.toString(ss) + " iterations.");
        pw.println();
        String canonicalName = (this.payload ? BlackholePipelinePayloadBench.class : BlackholePipelineBench.class).getCanonicalName();
        pw.printf("%12s", "");
        for (int steps : ss) {
            pw.printf("%16s", steps);
        }
        pw.println();
        for (String type : types) {
            pw.printf("%12s", type + ": ");
            for (int steps : ss) {
                Options opts = new OptionsBuilder().parent(parent).include(canonicalName + ".test_" + type).param("steps", String.valueOf(steps)).verbosity(VerboseMode.SILENT).build();
                RunResult result = new Runner(opts).runSingle();
                Result r = result.getPrimaryResult();
                pw.printf("%16s", String.format("%.2f \u00b1 %.2f", r.getScore() / (double)steps, r.getScoreError() / (double)steps));
                pw.flush();
            }
            pw.println();
        }
        pw.println();
    }
}

