/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import org.openjdk.jmh.benchmarks.BlackholeConsumeCPUBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;

public class BlackholeConsumeCPUTest
extends ValidationTest {
    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- BLACKHOLE CONSUME CPU TEST");
        pw.println();
        Utils.reflow(pw, "This test assesses the Blackhole.consumeCPU performance, that should be linear to the number of tokens. The performance can be slightly different on low token counts. Otherwise, the backoffs with consumeCPU are not reliable. ", 80, 2);
        pw.println();
        pw.println("  Scores are (normalized) nanoseconds per token.");
        pw.println();
        pw.printf("%20s%n", "#Tokens: ");
        for (int delay : new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 500, 1000, 5000, 10000, 50000, 100000, 500000, 1000000, 5000000, 10000000}) {
            Options opts = new OptionsBuilder().parent(parent).include(BlackholeConsumeCPUBench.class.getCanonicalName()).verbosity(VerboseMode.SILENT).param("delay", String.valueOf(delay)).build();
            RunResult result = new Runner(opts).runSingle();
            Result r = result.getPrimaryResult();
            pw.printf("%20s", delay + ": ");
            pw.flush();
            pw.printf("%.2f \u00b1 %.2f ns\n", r.getScore() / (double)delay, r.getScoreError() / (double)delay);
        }
        pw.println();
    }
}

