/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation;

import java.io.PrintWriter;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.tests.BlackholeTestMode;

public abstract class ValidationTest {
    public abstract void runWith(PrintWriter var1, Options var2) throws RunnerException;

    protected String blackholeModeString(BlackholeTestMode mode) {
        switch (mode) {
            case normal: {
                return "DEFAULT";
            }
            case compiler: {
                return "COMPILER BLACKHOLE";
            }
            case full_dontinline: {
                return "FULL BLACKHOLE, NO INLINE";
            }
            case full: {
                return "FULL BLACKHOLE";
            }
        }
        throw new IllegalStateException("Unknown blackhole mode: " + (Object)((Object)mode));
    }

    protected void blackholeModeMessage(PrintWriter pw, BlackholeTestMode mode) {
        switch (mode) {
            case normal: {
                break;
            }
            case compiler: {
                Utils.reflow(pw, "This particular test mode enables the compiler-assisted blackholes. It should provide the most consistent performance across all types. This mode is only available in modern JDKs.", 80, 2);
                pw.println();
                break;
            }
            case full_dontinline: {
                Utils.reflow(pw, "This particular test mode omits the compiler-assisted blackholes. It should provide the basic level of safety for all JDKs.", 80, 2);
                pw.println();
                break;
            }
            case full: {
                Utils.reflow(pw, "This particular test mode forces the inline of Blackhole methods, and so demolishes two of the layers in defence in depth. If this layer is broken, Blackhole should also survive. If it isn't, then JMH will have to provide more contingencies.", 80, 2);
                pw.println();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown blackhole mode: " + (Object)((Object)mode));
            }
        }
    }
}

