/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConversionException;
import org.openjdk.jmh.runner.CompilerHints;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.CommandLineOptionException;
import org.openjdk.jmh.runner.options.OptionFormatter;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.util.Version;
import org.openjdk.jmh.validation.tests.BlackholeConsecutiveTest;
import org.openjdk.jmh.validation.tests.BlackholeConsumeCPUTest;
import org.openjdk.jmh.validation.tests.BlackholePipelinedTest;
import org.openjdk.jmh.validation.tests.BlackholeSingleTest;
import org.openjdk.jmh.validation.tests.BlackholeTestMode;
import org.openjdk.jmh.validation.tests.BurstStabilityTest;
import org.openjdk.jmh.validation.tests.CompilerHintsTest;
import org.openjdk.jmh.validation.tests.CoreStabilityTest;
import org.openjdk.jmh.validation.tests.HelperMethodsTest;
import org.openjdk.jmh.validation.tests.LongStabilityTest;
import org.openjdk.jmh.validation.tests.RoundTripLatencyTest;
import org.openjdk.jmh.validation.tests.ThermalRundownTest;
import org.openjdk.jmh.validation.tests.ThreadScalingTest;
import org.openjdk.jmh.validation.tests.TimingMeasurementsTest;

public class Main {
    public static void main(String[] args) throws RunnerException, CommandLineOptionException, IOException {
        Mode mode;
        List<Test> tests;
        PrintWriter pw = new PrintWriter(System.out, true);
        pw.println("JMH Core Benchmarks, Validation Tests");
        pw.println("----------------------------------------------------------------------------------------------------------");
        pw.println();
        pw.println("# " + Version.getVersion());
        pw.println("# " + Utils.getCurrentJvmVersion());
        pw.println("# " + Utils.getCurrentOSVersion());
        pw.println();
        Utils.reflow(pw, "These tests assess the current benchmarking environment health, including hardware, OS, JVM, and JMH itself. While the failure on these tests does not immediately means the problem with environment, it is instructive to understand and follow up on oddities in these tests.", 80, 2);
        pw.println();
        Utils.reflow(pw, "If you are sharing this report, please share it in full, including the JVM version, OS flavor and version, plus some data on used hardware.", 80, 2);
        pw.println();
        pw.println("  Use -h to get help on available options.");
        pw.println();
        OptionParser parser = new OptionParser();
        parser.formatHelpWith(new OptionFormatter());
        ArgumentAcceptingOptionSpec<Test> optTests = parser.accepts("t", "Test names.").withRequiredArg().ofType(Test.class).withValuesSeparatedBy(',').describedAs("string").defaultsTo((Test[])Test.values());
        ArgumentAcceptingOptionSpec<Mode> optMode = parser.accepts("m", "Running mode, one of " + Arrays.toString((Object[])Mode.values()) + ".").withRequiredArg().ofType(Mode.class).describedAs("mode").defaultsTo(Mode.normal, (Mode[])new Mode[0]);
        parser.accepts("h", "Print help.");
        try {
            OptionSet set = parser.parse(args);
            if (set.has("h")) {
                parser.printHelpOn(System.out);
                return;
            }
            tests = set.valuesOf(optTests);
            mode = set.valueOf(optMode);
        }
        catch (OptionException e) {
            String message = e.getMessage();
            Throwable cause = e.getCause();
            if (cause instanceof ValueConversionException) {
                message = message + ". " + cause.getMessage();
            }
            throw new CommandLineOptionException(message, e);
        }
        Options opts = new OptionsBuilder().detectJvmArgs().jvmArgsAppend("-Xmx512m", "-Xms512m", "-server").build();
        switch (mode) {
            case flash: {
                opts = new OptionsBuilder().parent(opts).warmupIterations(3).warmupTime(TimeValue.milliseconds(10L)).measurementIterations(3).measurementTime(TimeValue.milliseconds(10L)).forks(1).build();
                break;
            }
            case quick: {
                opts = new OptionsBuilder().parent(opts).warmupIterations(3).warmupTime(TimeValue.milliseconds(100L)).measurementIterations(3).measurementTime(TimeValue.milliseconds(100L)).forks(3).build();
                break;
            }
            case normal: {
                opts = new OptionsBuilder().parent(opts).warmupIterations(5).warmupTime(TimeValue.milliseconds(500L)).measurementIterations(5).measurementTime(TimeValue.milliseconds(500L)).forks(5).build();
                break;
            }
            case longer: {
                opts = new OptionsBuilder().parent(opts).warmupIterations(10).warmupTime(TimeValue.seconds(1L)).measurementIterations(10).measurementTime(TimeValue.seconds(1L)).forks(10).build();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        block35: for (Test t : tests) {
            switch (t) {
                case timing: {
                    new TimingMeasurementsTest().runWith(pw, opts);
                    continue block35;
                }
                case long_stability: {
                    switch (mode) {
                        case flash: {
                            new LongStabilityTest(3).runWith(pw, opts);
                            continue block35;
                        }
                        case quick: {
                            new LongStabilityTest(5).runWith(pw, opts);
                            continue block35;
                        }
                        case normal: {
                            new LongStabilityTest(18).runWith(pw, opts);
                            continue block35;
                        }
                        case longer: {
                            new LongStabilityTest(60).runWith(pw, opts);
                            continue block35;
                        }
                    }
                    throw new IllegalStateException();
                }
                case burst_stability: {
                    new BurstStabilityTest().runWith(pw, opts);
                    continue block35;
                }
                case core_stability: {
                    new CoreStabilityTest().runWith(pw, opts);
                    continue block35;
                }
                case compiler_hints: {
                    new CompilerHintsTest().runWith(pw, opts);
                    continue block35;
                }
                case thermal: {
                    switch (mode) {
                        case flash: {
                            new ThermalRundownTest(3).runWith(pw, opts);
                            continue block35;
                        }
                        case quick: {
                            new ThermalRundownTest(5).runWith(pw, opts);
                            continue block35;
                        }
                        case normal: {
                            new ThermalRundownTest(18).runWith(pw, opts);
                            continue block35;
                        }
                        case longer: {
                            new ThermalRundownTest(60).runWith(pw, opts);
                            continue block35;
                        }
                    }
                    throw new IllegalStateException();
                }
                case helpers: {
                    new HelperMethodsTest().runWith(pw, opts);
                    continue block35;
                }
                case thread_scale: {
                    new ThreadScalingTest().runWith(pw, opts);
                    continue block35;
                }
                case blackhole_cpu: {
                    new BlackholeConsumeCPUTest().runWith(pw, opts);
                    continue block35;
                }
                case blackhole_single: {
                    Main.setBlackholeOpts(BlackholeTestMode.normal);
                    new BlackholeSingleTest(BlackholeTestMode.normal).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.compiler);
                    new BlackholeSingleTest(BlackholeTestMode.compiler).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.full_dontinline);
                    new BlackholeSingleTest(BlackholeTestMode.full_dontinline).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.full);
                    new BlackholeSingleTest(BlackholeTestMode.full).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.normal);
                    continue block35;
                }
                case blackhole_pipelined: {
                    Main.setBlackholeOpts(BlackholeTestMode.normal);
                    new BlackholePipelinedTest(false, BlackholeTestMode.normal).runWith(pw, opts);
                    new BlackholePipelinedTest(true, BlackholeTestMode.normal).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.compiler);
                    new BlackholePipelinedTest(false, BlackholeTestMode.compiler).runWith(pw, opts);
                    new BlackholePipelinedTest(true, BlackholeTestMode.compiler).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.full_dontinline);
                    new BlackholePipelinedTest(false, BlackholeTestMode.full_dontinline).runWith(pw, opts);
                    new BlackholePipelinedTest(true, BlackholeTestMode.full_dontinline).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.full);
                    new BlackholePipelinedTest(false, BlackholeTestMode.full).runWith(pw, opts);
                    new BlackholePipelinedTest(true, BlackholeTestMode.full).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.normal);
                    continue block35;
                }
                case blackhole_consec: {
                    Main.setBlackholeOpts(BlackholeTestMode.normal);
                    new BlackholeConsecutiveTest(BlackholeTestMode.normal).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.compiler);
                    new BlackholeConsecutiveTest(BlackholeTestMode.compiler).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.full_dontinline);
                    new BlackholeConsecutiveTest(BlackholeTestMode.full_dontinline).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.full);
                    new BlackholeConsecutiveTest(BlackholeTestMode.full).runWith(pw, opts);
                    Main.setBlackholeOpts(BlackholeTestMode.normal);
                    continue block35;
                }
                case roundtrip_latency: {
                    new RoundTripLatencyTest(false).runWith(pw, opts);
                    new RoundTripLatencyTest(true).runWith(pw, opts);
                    continue block35;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static void setBlackholeOpts(BlackholeTestMode mode) {
        switch (mode) {
            case normal: {
                System.getProperties().remove("jmh.blackhole.mode");
                break;
            }
            case compiler: {
                System.getProperties().setProperty("jmh.blackhole.mode", "COMPILER");
                break;
            }
            case full_dontinline: {
                System.getProperties().setProperty("jmh.blackhole.mode", "FULL_DONTINLINE");
                break;
            }
            case full: {
                System.getProperties().setProperty("jmh.blackhole.mode", "FULL");
            }
        }
        try {
            Field f = CompilerHints.class.getDeclaredField("hintsFile");
            f.setAccessible(true);
            f.set(null, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static enum Test {
        timing,
        compiler_hints,
        thermal,
        long_stability,
        burst_stability,
        core_stability,
        thread_scale,
        helpers,
        blackhole_cpu,
        blackhole_single,
        blackhole_pipelined,
        blackhole_consec,
        roundtrip_latency;

    }

    public static enum Mode {
        flash,
        quick,
        normal,
        longer;

    }
}

