/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AffinitySupport {
    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static boolean isSupported() {
        return AffinitySupport.isLinux();
    }

    public static void bind(int cpu) {
        if (!AffinitySupport.isLinux()) {
            throw new IllegalStateException("Not implemented");
        }
        Linux.bind(cpu);
    }

    public static void tryBind() {
        if (!AffinitySupport.isLinux()) {
            throw new IllegalStateException("Not implemented");
        }
        Linux.tryBind();
    }

    public static List<String> prepare() {
        if (AffinitySupport.isLinux()) {
            return Linux.prepare();
        }
        throw new IllegalStateException("Not implemented");
    }

    public static void tryInit() {
        if (AffinitySupport.isLinux()) {
            Linux.tryInit();
        }
    }

    static class Linux {
        private static volatile CLibrary INSTANCE;
        private static boolean BIND_TRIED;

        Linux() {
        }

        public static List<String> prepare() {
            System.setProperty("jnidispatch.preserve", "true");
            Native.load("c", CLibrary.class);
            File file = new File(System.getProperty("jnidispatch.path"));
            String bootLibraryPath = file.getParent();
            File proper = new File(bootLibraryPath + '/' + System.mapLibraryName("jnidispatch"));
            if (!file.renameTo(proper)) {
                throw new IllegalStateException("Failed to rename " + file + " to " + proper);
            }
            return Arrays.asList("-Djna.nounpack=true", "-Djna.nosys=true", "-Djna.noclasspath=true", "-Djna.boot.library.path=" + bootLibraryPath, "-Djna.platform.library.path=" + System.getProperty("jna.platform.library.path"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void tryInit() {
            if (INSTANCE != null) return;
            Class<Linux> clazz = Linux.class;
            synchronized (Linux.class) {
                if (INSTANCE != null) return;
                INSTANCE = Native.load("c", CLibrary.class);
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        public static void bind(int cpu) {
            Linux.tryInit();
            cpu_set_t cpuset = new cpu_set_t();
            cpuset.set(cpu);
            Linux.set(cpuset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void tryBind() {
            if (BIND_TRIED) {
                return;
            }
            Class<Linux> clazz = Linux.class;
            synchronized (Linux.class) {
                if (BIND_TRIED) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                Linux.tryInit();
                cpu_set_t cs = new cpu_set_t();
                Linux.get(cs);
                Linux.set(cs);
                BIND_TRIED = true;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        private static void get(cpu_set_t cpuset) {
            if (INSTANCE.sched_getaffinity(0, cpu_set_t.SIZE_OF, cpuset) != 0) {
                throw new IllegalStateException("Failed: " + Native.getLastError());
            }
        }

        private static void set(cpu_set_t cpuset) {
            if (INSTANCE.sched_setaffinity(0, cpu_set_t.SIZE_OF, cpuset) != 0) {
                throw new IllegalStateException("Failed: " + Native.getLastError());
            }
        }

        static interface CLibrary
        extends Library {
            public int sched_getaffinity(int var1, int var2, cpu_set_t var3);

            public int sched_setaffinity(int var1, int var2, cpu_set_t var3);
        }

        public static class cpu_set_t
        extends Structure {
            private static final int CPUSET_SIZE = 1024;
            private static final int NCPU_BITS = 8 * NativeLong.SIZE;
            private static final int SIZE_OF = 1024 / NCPU_BITS * NativeLong.SIZE;
            public NativeLong[] __bits = new NativeLong[1024 / NCPU_BITS];

            public cpu_set_t() {
                for (int i = 0; i < this.__bits.length; ++i) {
                    this.__bits[i] = new NativeLong(0L);
                }
            }

            public void set(int cpu) {
                int cIdx = cpu / NCPU_BITS;
                long mask = 1L << cpu % NCPU_BITS;
                NativeLong bit = this.__bits[cIdx];
                bit.setValue(bit.longValue() | mask);
            }

            @Override
            protected List<String> getFieldOrder() {
                return Collections.singletonList("__bits");
            }
        }
    }
}

