/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.benchmarks;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.validation.AffinitySupport;
import org.openjdk.jmh.validation.SpinWaitSupport;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
public class RoundTripLatencyBench {
    static final boolean SPINWAIT = Boolean.getBoolean("spinWait");
    @Param(value={"-1"})
    int p;
    @Param(value={"-1"})
    int c;
    Thread t;
    volatile boolean ping;

    @Setup
    public void setup() {
        if (this.c != -1) {
            AffinitySupport.bind(this.c);
        }
        this.t = new Thread(() -> {
            if (this.p != -1) {
                AffinitySupport.bind(this.p);
            }
            Thread t = Thread.currentThread();
            while (!t.isInterrupted()) {
                while (!this.ping) {
                    if (!SPINWAIT) continue;
                    SpinWaitSupport.onSpinWait();
                }
                this.ping = false;
            }
        });
        this.t.start();
    }

    @TearDown
    public void tearDown() throws InterruptedException {
        this.t.interrupt();
        this.ping = true;
        this.t.join();
    }

    @Benchmark
    public void test() {
        this.ping = true;
        while (this.ping) {
            if (!SPINWAIT) continue;
            SpinWaitSupport.onSpinWait();
        }
    }
}

