/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.benchmarks;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class BlackholePipelineBench {
    @Param(value={"10"})
    private int steps;
    private boolean[] booleans;
    private byte[] bytes;
    private short[] shorts;
    private char[] chars;
    private int[] ints;
    private float[] floats;
    private long[] longs;
    private double[] doubles;
    private Object[] objects;
    private Object[][] arrays;

    @Setup
    public void prepare() {
        this.booleans = new boolean[this.steps];
        this.bytes = new byte[this.steps];
        this.shorts = new short[this.steps];
        this.chars = new char[this.steps];
        this.ints = new int[this.steps];
        this.floats = new float[this.steps];
        this.longs = new long[this.steps];
        this.doubles = new double[this.steps];
        this.objects = new Object[this.steps];
        this.arrays = new Object[this.steps][];
        Random r = new Random(0L);
        for (int c = 0; c < this.steps; ++c) {
            this.booleans[c] = r.nextBoolean();
            this.bytes[c] = (byte)r.nextInt();
            this.shorts[c] = (short)r.nextInt();
            this.chars[c] = (char)r.nextInt();
            this.ints[c] = r.nextInt();
            this.floats[c] = r.nextFloat();
            this.longs[c] = r.nextLong();
            this.doubles[c] = r.nextDouble();
            this.objects[c] = new Object();
            this.arrays[c] = new Object[10];
        }
    }

    @Benchmark
    public void test_boolean(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(this.booleans[c]);
        }
    }

    @Benchmark
    public void test_byte(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(this.bytes[c]);
        }
    }

    @Benchmark
    public void test_short(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(this.shorts[c]);
        }
    }

    @Benchmark
    public void test_char(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(this.chars[c]);
        }
    }

    @Benchmark
    public void test_int(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(this.ints[c]);
        }
    }

    @Benchmark
    public void test_float(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(this.floats[c]);
        }
    }

    @Benchmark
    public void test_long(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(this.longs[c]);
        }
    }

    @Benchmark
    public void test_double(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(this.doubles[c]);
        }
    }

    @Benchmark
    public void test_Object(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(this.objects[c]);
        }
    }

    @Benchmark
    public void test_Array(Blackhole bh) {
        for (int c = 0; c < this.steps; ++c) {
            bh.consume(this.arrays[c]);
        }
    }
}

