/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.server.util.timer.TimerTask;
import org.apache.kafka.server.util.timer.TimerTaskEntry;
import org.apache.kafka.server.util.timer.TimerTaskList;
import org.apache.kafka.server.util.timer.TimingWheel;

public class SystemTimer
implements Timer {
    private final ExecutorService taskExecutor;
    private final DelayQueue<TimerTaskList> delayQueue;
    private final AtomicInteger taskCounter;
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    public SystemTimer(String executorName) {
        this(executorName, 1L, 20, Time.SYSTEM.hiResClockMs());
    }

    public SystemTimer(String executorName, long tickMs, int wheelSize, long startMs) {
        this.taskExecutor = Executors.newFixedThreadPool(1, runnable -> KafkaThread.nonDaemon("executor-" + executorName, runnable));
        this.delayQueue = new DelayQueue();
        this.taskCounter = new AtomicInteger(0);
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
    }

    @Override
    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.addTimerTaskEntry(new TimerTaskEntry(timerTask, timerTask.delayMs + Time.SYSTEM.hiResClockMs()));
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addTimerTaskEntry(TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry) && !timerTaskEntry.cancelled()) {
            this.taskExecutor.submit(timerTaskEntry.timerTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean advanceClock(long timeoutMs) throws InterruptedException {
        TimerTaskList bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        if (bucket != null) {
            this.writeLock.lock();
            try {
                while (bucket != null) {
                    this.timingWheel.advanceClock(bucket.getExpiration());
                    bucket.flush(this::addTimerTaskEntry);
                    bucket = (TimerTaskList)this.delayQueue.poll();
                }
            }
            finally {
                this.writeLock.unlock();
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.taskCounter.get();
    }

    @Override
    public void close() {
        this.taskExecutor.shutdown();
    }
}

