/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.kafka.common.internals.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TopicFilter {
    protected final String regex;
    private final Pattern pattern;

    public TopicFilter(String rawRegex) {
        this.regex = rawRegex.trim().replace(',', '|').replace(" ", "").replaceAll("^[\"']+", "").replaceAll("[\"']+$", "");
        try {
            this.pattern = Pattern.compile(this.regex);
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException(this.regex + " is an invalid regex.");
        }
    }

    public abstract boolean isTopicAllowed(String var1, boolean var2);

    public String toString() {
        return this.regex;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public static class IncludeList
    extends TopicFilter {
        private final Logger log = LoggerFactory.getLogger(IncludeList.class);

        public IncludeList(String rawRegex) {
            super(rawRegex);
        }

        @Override
        public boolean isTopicAllowed(String topic, boolean excludeInternalTopics) {
            boolean allowed;
            boolean bl = allowed = topic.matches(this.regex) && (!Topic.isInternal(topic) || !excludeInternalTopics);
            if (allowed) {
                this.log.debug("{} allowed", (Object)topic);
            } else {
                this.log.debug("{} filtered", (Object)topic);
            }
            return allowed;
        }
    }
}

