/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import java.util.Optional;
import org.apache.kafka.server.util.json.JsonValue;

public final class Json {
    private static ObjectMapper mapper = new ObjectMapper();

    public static Optional<JsonValue> parseFull(String input) {
        try {
            return Optional.ofNullable(Json.tryParseFull(input));
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    public static <T> T parseStringAs(String input, Class<T> clazz) throws JsonProcessingException {
        return mapper.readValue(input, clazz);
    }

    public static Optional<JsonValue> parseBytes(byte[] input) throws IOException {
        try {
            return Optional.ofNullable(mapper.readTree(input)).map(JsonValue::apply);
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    public static JsonValue tryParseBytes(byte[] input) throws IOException {
        return JsonValue.apply(mapper.readTree(input));
    }

    public static <T> T parseBytesAs(byte[] input, Class<T> clazz) throws IOException {
        return mapper.readValue(input, clazz);
    }

    public static JsonValue tryParseFull(String input) throws JsonProcessingException {
        if (input == null || input.isEmpty()) {
            throw new JsonParseException(MissingNode.getInstance().traverse(), "The input string shouldn't be empty");
        }
        return JsonValue.apply(mapper.readTree(input));
    }

    public static String encodeAsString(Object obj) throws JsonProcessingException {
        return mapper.writeValueAsString(obj);
    }

    public static byte[] encodeAsBytes(Object obj) throws JsonProcessingException {
        return mapper.writeValueAsBytes(obj);
    }
}

