/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Deadline;
import org.slf4j.Logger;

public class FutureUtils {
    public static <T> T waitWithLogging(Logger log, String prefix, String action, CompletableFuture<T> future, Deadline deadline, Time time) throws Throwable {
        log.info("{}Waiting for {}", (Object)prefix, (Object)action);
        try {
            T result = time.waitForFuture(future, deadline.nanoseconds());
            log.info("{}Finished waiting for {}", (Object)prefix, (Object)action);
            return result;
        }
        catch (TimeoutException t) {
            log.error("{}Timed out while waiting for {}", prefix, action, t);
            TimeoutException timeout = new TimeoutException("Timed out while waiting for " + action);
            timeout.setStackTrace(t.getStackTrace());
            throw timeout;
        }
        catch (Throwable t) {
            if (t instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)t;
                t = executionException.getCause();
            }
            log.error("{}Received a fatal error while waiting for {}", prefix, action, t);
            throw new RuntimeException("Received a fatal error while waiting for " + action, t);
        }
    }

    public static <T> void chainFuture(CompletableFuture<? extends T> sourceFuture, final CompletableFuture<T> destinationFuture) {
        sourceFuture.whenComplete(new BiConsumer<T, Throwable>(){

            @Override
            public void accept(T val, Throwable throwable) {
                if (throwable != null) {
                    destinationFuture.completeExceptionally(throwable);
                } else {
                    destinationFuture.complete(val);
                }
            }
        });
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }
}

