/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.util.CommandDefaultOptions;

public class CommandLineUtils {
    public static boolean isPrintHelpNeeded(CommandDefaultOptions commandOpts) {
        return commandOpts.args.length == 0 || commandOpts.options.has(commandOpts.helpOpt);
    }

    public static boolean isPrintVersionNeeded(CommandDefaultOptions commandOpts) {
        return commandOpts.options.has(commandOpts.versionOpt);
    }

    public static void maybePrintHelpOrVersion(CommandDefaultOptions commandOpts, String message) {
        if (CommandLineUtils.isPrintHelpNeeded(commandOpts)) {
            CommandLineUtils.printUsageAndExit(commandOpts.parser, message);
        }
        if (CommandLineUtils.isPrintVersionNeeded(commandOpts)) {
            CommandLineUtils.printVersionAndExit();
        }
    }

    public static void checkRequiredArgs(OptionParser parser, OptionSet options, OptionSpec<?> ... requiredList) {
        for (OptionSpec<?> arg : requiredList) {
            if (options.has(arg)) continue;
            CommandLineUtils.printUsageAndExit(parser, String.format("Missing required argument \"%s\"", arg));
        }
    }

    public static void checkInvalidArgs(OptionParser parser, OptionSet options, OptionSpec<?> usedOption, OptionSpec<?> ... invalidOptions) {
        if (options.has(usedOption)) {
            for (OptionSpec<?> arg : invalidOptions) {
                if (!options.has(arg)) continue;
                CommandLineUtils.printUsageAndExit(parser, String.format("Option \"%s\" can't be used with option \"%s\"", usedOption, arg));
            }
        }
    }

    public static void checkInvalidArgs(OptionParser parser, OptionSet options, OptionSpec<?> usedOption, Set<OptionSpec<?>> invalidOptions) {
        OptionSpec[] array = new OptionSpec[invalidOptions.size()];
        invalidOptions.toArray(array);
        CommandLineUtils.checkInvalidArgs(parser, options, usedOption, array);
    }

    public static void checkInvalidArgsSet(OptionParser parser, OptionSet options, Set<OptionSpec<?>> usedOptions, Set<OptionSpec<?>> invalidOptions, Optional<String> trailingAdditionalMessage) {
        if (usedOptions.stream().filter(options::has).count() == (long)usedOptions.size()) {
            for (OptionSpec<?> arg : invalidOptions) {
                if (!options.has(arg)) continue;
                CommandLineUtils.printUsageAndExit(parser, String.format("Option combination \"%s\" can't be used with option \"%s\"%s", usedOptions, arg, trailingAdditionalMessage.orElse("")));
            }
        }
    }

    public static void printUsageAndExit(OptionParser parser, String message) {
        System.err.println(message);
        try {
            parser.printHelpOn(System.err);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Exit.exit(1, message);
    }

    public static void printVersionAndExit() {
        System.out.println(AppInfoParser.getVersion());
        Exit.exit(0);
    }

    public static Properties parseKeyValueArgs(List<String> args) {
        return CommandLineUtils.parseKeyValueArgs(args, true);
    }

    public static Properties parseKeyValueArgs(List<String> args, boolean acceptMissingValue) {
        Properties props = new Properties();
        ArrayList splits = new ArrayList();
        args.forEach(arg -> {
            String[] split = arg.split("=", 2);
            if (split.length > 0) {
                splits.add(split);
            }
        });
        splits.forEach(split -> {
            if (((String[])split).length == 1 || ((String[])split).length == 2 && (split[1] == null || split[1].isEmpty())) {
                if (!acceptMissingValue) throw new IllegalArgumentException(String.format("Missing value for key %s}", split[0]));
                props.put(split[0], "");
                return;
            } else {
                props.put(split[0], split[1]);
            }
        });
        return props;
    }

    public static <T> void maybeMergeOptions(Properties props, String key, OptionSet options, OptionSpec<T> spec) {
        if (options.has(spec) || !props.containsKey(key)) {
            T value = options.valueOf(spec);
            if (value == null) {
                props.remove(key);
            } else {
                props.put(key, value.toString());
            }
        }
    }
}

