/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.slf4j.Logger;

public class EndpointReadyFutures {
    private final Logger log;
    private final Map<Endpoint, CompletableFuture<Void>> futures;

    private EndpointReadyFutures(LogContext logContext, Map<Endpoint, List<EndpointCompletionStage>> endpointStages) {
        this.log = logContext.logger(EndpointReadyFutures.class);
        HashMap newFutures = new HashMap();
        endpointStages.forEach((endpoint, stages) -> {
            ArrayList<String> stageNames = new ArrayList<String>();
            stages.forEach(stage -> stageNames.add(stage.name));
            EndpointReadyFuture readyFuture = new EndpointReadyFuture((Endpoint)endpoint, (Collection<String>)stageNames);
            newFutures.put(endpoint, readyFuture.future);
            stages.forEach(stage -> stage.future.whenComplete((__, exception) -> {
                if (exception != null) {
                    readyFuture.failStage(stage.name, (Throwable)exception);
                } else {
                    readyFuture.completeStage(stage.name);
                }
            }));
        });
        this.futures = Collections.unmodifiableMap(newFutures);
    }

    public Map<Endpoint, CompletableFuture<Void>> futures() {
        return this.futures;
    }

    class EndpointReadyFuture {
        final String endpointName;
        final TreeSet<String> incomplete;
        final CompletableFuture<Void> future;

        EndpointReadyFuture(Endpoint endpoint, Collection<String> stageNames) {
            this.endpointName = endpoint.listenerName().orElse("UNNAMED");
            this.incomplete = new TreeSet<String>(stageNames);
            this.future = new CompletableFuture();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void completeStage(String stageName) {
            boolean done = false;
            EndpointReadyFuture endpointReadyFuture = this;
            synchronized (endpointReadyFuture) {
                if (this.incomplete.remove(stageName)) {
                    if (this.incomplete.isEmpty()) {
                        done = true;
                    } else {
                        EndpointReadyFutures.this.log.info("{} completed for endpoint {}. Still waiting for {}.", stageName, this.endpointName, this.incomplete);
                    }
                }
            }
            if (done && this.future.complete(null)) {
                EndpointReadyFutures.this.log.info("{} completed for endpoint {}. Endpoint is now READY.", (Object)stageName, (Object)this.endpointName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void failStage(String what, Throwable exception) {
            if (this.future.completeExceptionally(exception)) {
                EndpointReadyFuture endpointReadyFuture = this;
                synchronized (endpointReadyFuture) {
                    this.incomplete.clear();
                }
                EndpointReadyFutures.this.log.warn("Endpoint {} will never become ready because we encountered an {} exception", this.endpointName, what, exception);
            }
        }
    }

    static class EndpointCompletionStage {
        final String name;
        final CompletionStage<?> future;

        EndpointCompletionStage(String name, CompletionStage<?> future) {
            this.name = name;
            this.future = future;
        }
    }

    public static class Builder {
        private LogContext logContext = null;
        private final Map<Endpoint, List<EndpointCompletionStage>> endpointStages = new HashMap<Endpoint, List<EndpointCompletionStage>>();
        private final List<EndpointCompletionStage> stages = new ArrayList<EndpointCompletionStage>();

        public Builder addReadinessFuture(String name, CompletableFuture<?> future) {
            this.stages.add(new EndpointCompletionStage(name, future));
            return this;
        }

        public Builder addReadinessFutures(String name, Map<Endpoint, ? extends CompletionStage<?>> newFutures) {
            newFutures.forEach((endpoint, future) -> this.endpointStages.computeIfAbsent((Endpoint)endpoint, __ -> new ArrayList()).add(new EndpointCompletionStage(name, (CompletionStage<?>)future)));
            return this;
        }

        public EndpointReadyFutures build(Optional<Authorizer> authorizer, AuthorizerServerInfo info) {
            if (authorizer.isPresent()) {
                return this.build(authorizer.get().start(info), info);
            }
            return this.build(Collections.emptyMap(), info);
        }

        EndpointReadyFutures build(Map<Endpoint, ? extends CompletionStage<?>> authorizerStartFutures, AuthorizerServerInfo info) {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            HashMap effectiveStartFutures = new HashMap(authorizerStartFutures);
            for (Endpoint endpoint : info.endpoints()) {
                if (effectiveStartFutures.containsKey(endpoint)) continue;
                CompletableFuture<Object> completedFuture = CompletableFuture.completedFuture(null);
                effectiveStartFutures.put(endpoint, completedFuture);
            }
            if (info.endpoints().size() != effectiveStartFutures.size()) {
                ArrayList<String> notInInfo = new ArrayList<String>();
                for (Endpoint endpoint : effectiveStartFutures.keySet()) {
                    if (info.endpoints().contains(endpoint)) continue;
                    notInInfo.add(endpoint.listenerName().orElse("[none]"));
                }
                throw new RuntimeException("Found authorizer futures that weren't included in AuthorizerServerInfo: " + notInInfo);
            }
            this.addReadinessFutures("authorizerStart", effectiveStartFutures);
            this.stages.forEach(stage -> {
                HashMap newReadinessFutures = new HashMap();
                info.endpoints().forEach(endpoint -> newReadinessFutures.put(endpoint, stage.future));
                this.addReadinessFutures(stage.name, newReadinessFutures);
            });
            return new EndpointReadyFutures(this.logContext, this.endpointStages);
        }
    }
}

