/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import com.yammer.metrics.core.MetricName;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class RemoteStorageMetrics {
    private static final String REMOTE_LOG_READER_METRICS_NAME_PREFIX = "RemoteLogReader";
    private static final String REMOTE_LOG_MANAGER_TASKS_AVG_IDLE_PERCENT = "RemoteLogManagerTasksAvgIdlePercent";
    private static final String TASK_QUEUE_SIZE = "TaskQueueSize";
    private static final String AVG_IDLE_PERCENT = "AvgIdlePercent";
    private static final String REMOTE_COPY_BYTES_PER_SEC = "RemoteCopyBytesPerSec";
    private static final String REMOTE_FETCH_BYTES_PER_SEC = "RemoteFetchBytesPerSec";
    private static final String REMOTE_FETCH_REQUESTS_PER_SEC = "RemoteFetchRequestsPerSec";
    private static final String REMOTE_COPY_REQUESTS_PER_SEC = "RemoteCopyRequestsPerSec";
    private static final String FAILED_REMOTE_FETCH_PER_SEC = "RemoteFetchErrorsPerSec";
    private static final String FAILED_REMOTE_COPY_PER_SEC = "RemoteCopyErrorsPerSec";
    private static final String REMOTE_LOG_READER_TASK_QUEUE_SIZE = "RemoteLogReaderTaskQueueSize";
    private static final String REMOTE_LOG_READER_AVG_IDLE_PERCENT = "RemoteLogReaderAvgIdlePercent";
    public static final Set<String> REMOTE_STORAGE_THREAD_POOL_METRICS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("RemoteLogReaderTaskQueueSize", "RemoteLogReaderAvgIdlePercent")));
    public static final MetricName REMOTE_COPY_BYTES_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteCopyBytesPerSec");
    public static final MetricName REMOTE_FETCH_BYTES_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteFetchBytesPerSec");
    public static final MetricName REMOTE_FETCH_REQUESTS_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteFetchRequestsPerSec");
    public static final MetricName REMOTE_COPY_REQUESTS_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteCopyRequestsPerSec");
    public static final MetricName FAILED_REMOTE_FETCH_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteFetchErrorsPerSec");
    public static final MetricName FAILED_REMOTE_COPY_PER_SEC_METRIC = RemoteStorageMetrics.getMetricName("kafka.server", "BrokerTopicMetrics", "RemoteCopyErrorsPerSec");
    public static final MetricName REMOTE_LOG_MANAGER_TASKS_AVG_IDLE_PERCENT_METRIC = RemoteStorageMetrics.getMetricName("kafka.log.remote", "RemoteLogManager", "RemoteLogManagerTasksAvgIdlePercent");
    public static final MetricName REMOTE_LOG_READER_TASK_QUEUE_SIZE_METRIC = RemoteStorageMetrics.getMetricName("org.apache.kafka.storage.internals.log", "RemoteStorageThreadPool", "RemoteLogReaderTaskQueueSize");
    public static final MetricName REMOTE_LOG_READER_AVG_IDLE_PERCENT_METRIC = RemoteStorageMetrics.getMetricName("org.apache.kafka.storage.internals.log", "RemoteStorageThreadPool", "RemoteLogReaderAvgIdlePercent");

    public static Set<MetricName> allMetrics() {
        HashSet<MetricName> metrics = new HashSet<MetricName>();
        metrics.add(REMOTE_COPY_BYTES_PER_SEC_METRIC);
        metrics.add(REMOTE_FETCH_BYTES_PER_SEC_METRIC);
        metrics.add(REMOTE_FETCH_REQUESTS_PER_SEC_METRIC);
        metrics.add(REMOTE_COPY_REQUESTS_PER_SEC_METRIC);
        metrics.add(FAILED_REMOTE_FETCH_PER_SEC_METRIC);
        metrics.add(FAILED_REMOTE_COPY_PER_SEC_METRIC);
        metrics.add(REMOTE_LOG_MANAGER_TASKS_AVG_IDLE_PERCENT_METRIC);
        metrics.add(REMOTE_LOG_READER_AVG_IDLE_PERCENT_METRIC);
        metrics.add(REMOTE_LOG_READER_TASK_QUEUE_SIZE_METRIC);
        return metrics;
    }

    public static Set<MetricName> brokerTopicStatsMetrics() {
        HashSet<MetricName> metrics = new HashSet<MetricName>();
        metrics.add(REMOTE_COPY_BYTES_PER_SEC_METRIC);
        metrics.add(REMOTE_FETCH_BYTES_PER_SEC_METRIC);
        metrics.add(REMOTE_FETCH_REQUESTS_PER_SEC_METRIC);
        metrics.add(REMOTE_COPY_REQUESTS_PER_SEC_METRIC);
        metrics.add(FAILED_REMOTE_FETCH_PER_SEC_METRIC);
        metrics.add(FAILED_REMOTE_COPY_PER_SEC_METRIC);
        return metrics;
    }

    private static MetricName getMetricName(String group, String type, String name) {
        return KafkaYammerMetrics.getMetricName(group, type, name);
    }
}

