/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.fault;

import java.util.Objects;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.fault.FaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessTerminatingFaultHandler
implements FaultHandler {
    private static final Logger log = LoggerFactory.getLogger(ProcessTerminatingFaultHandler.class);
    private final Runnable action;
    private final boolean shouldHalt;

    private ProcessTerminatingFaultHandler(boolean shouldHalt, Runnable action) {
        this.shouldHalt = shouldHalt;
        this.action = action;
    }

    @Override
    public RuntimeException handleFault(String failureMessage, Throwable cause) {
        if (cause == null) {
            log.error("Encountered fatal fault: {}", (Object)failureMessage);
        } else {
            log.error("Encountered fatal fault: {}", (Object)failureMessage, (Object)cause);
        }
        try {
            this.action.run();
        }
        catch (Throwable e) {
            log.error("Failed to run terminating action.", e);
        }
        int statusCode = 1;
        if (this.shouldHalt) {
            Exit.halt(statusCode);
        } else {
            Exit.exit(statusCode);
        }
        return null;
    }

    public static final class Builder {
        private boolean shouldHalt = true;
        private Runnable action = () -> {};

        public Builder setShouldHalt(boolean value) {
            this.shouldHalt = value;
            return this;
        }

        public Builder setAction(Runnable action) {
            this.action = Objects.requireNonNull(action);
            return this;
        }

        public ProcessTerminatingFaultHandler build() {
            return new ProcessTerminatingFaultHandler(this.shouldHalt, this.action);
        }
    }
}

