/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSynonym {
    private static final Logger log = LoggerFactory.getLogger(ConfigSynonym.class);
    public static final Function<String, String> HOURS_TO_MILLISECONDS = input -> {
        int hours = ConfigSynonym.valueToInt(input, 0, "hoursToMilliseconds");
        return String.valueOf(TimeUnit.MILLISECONDS.convert(hours, TimeUnit.HOURS));
    };
    public static final Function<String, String> MINUTES_TO_MILLISECONDS = input -> {
        int hours = ConfigSynonym.valueToInt(input, 0, "minutesToMilliseconds");
        return String.valueOf(TimeUnit.MILLISECONDS.convert(hours, TimeUnit.MINUTES));
    };
    private final String name;
    private final Function<String, String> converter;

    private static int valueToInt(String input, int defaultValue, String what) {
        if (input == null) {
            return defaultValue;
        }
        String trimmedInput = input.trim();
        if (trimmedInput.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(trimmedInput);
        }
        catch (Exception e) {
            log.error("{} failed: unable to parse '{}' as an integer.", what, trimmedInput, e);
            return defaultValue;
        }
    }

    public ConfigSynonym(String name, Function<String, String> converter) {
        this.name = name;
        this.converter = converter;
    }

    public ConfigSynonym(String name) {
        this(name, Function.identity());
    }

    public String name() {
        return this.name;
    }

    public Function<String, String> converter() {
        return this.converter;
    }
}

