/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.UnsupportedTypeException;
import io.github.bucket4j.distributed.versioning.UsageOfObsoleteApiException;
import io.github.bucket4j.distributed.versioning.UsageOfUnsupportedApiException;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;

public abstract class AbstractBinaryTransaction {
    private final byte[] requestBytes;
    private Request<?> request;
    private long currentTimeNanos;

    protected AbstractBinaryTransaction(byte[] requestBytes) {
        this.requestBytes = requestBytes;
    }

    public byte[] execute() {
        try {
            this.request = InternalSerializationHelper.deserializeRequest(this.requestBytes);
        }
        catch (UnsupportedTypeException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.unsupportedType(e.getTypeId()), Versions.getOldest());
        }
        catch (UsageOfUnsupportedApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfUnsupportedApiException(e.getRequestedFormatNumber(), e.getMaxSupportedFormatNumber()), Versions.getOldest());
        }
        catch (UsageOfObsoleteApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfObsoleteApiException(e.getRequestedFormatNumber(), e.getMinSupportedFormatNumber()), Versions.getOldest());
        }
        Version backwardCompatibilityVersion = this.request.getBackwardCompatibilityVersion();
        try {
            RemoteBucketState currentState = null;
            if (this.exists()) {
                byte[] stateBytes = this.getRawState();
                currentState = InternalSerializationHelper.deserializeState(stateBytes);
            }
            MutableBucketEntry entryWrapper = new MutableBucketEntry(currentState);
            this.currentTimeNanos = this.request.getClientSideTime() != null ? this.request.getClientSideTime() : System.currentTimeMillis() * 1000000L;
            RemoteCommand<?> command = this.request.getCommand();
            CommandResult<?> result = command.execute(entryWrapper, this.currentTimeNanos);
            if (entryWrapper.isStateModified()) {
                RemoteBucketState newState = entryWrapper.get();
                this.setRawState(InternalSerializationHelper.serializeState(newState, backwardCompatibilityVersion), newState);
            }
            return InternalSerializationHelper.serializeResult(result, this.request.getBackwardCompatibilityVersion());
        }
        catch (UnsupportedTypeException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.unsupportedType(e.getTypeId()), backwardCompatibilityVersion);
        }
        catch (UsageOfUnsupportedApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfUnsupportedApiException(e.getRequestedFormatNumber(), e.getMaxSupportedFormatNumber()), backwardCompatibilityVersion);
        }
        catch (UsageOfObsoleteApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfObsoleteApiException(e.getRequestedFormatNumber(), e.getMinSupportedFormatNumber()), backwardCompatibilityVersion);
        }
    }

    protected abstract byte[] getRawState();

    protected abstract void setRawState(byte[] var1, RemoteBucketState var2);

    public abstract boolean exists();

    protected Request<?> getRequest() {
        return this.request;
    }

    protected ExpirationAfterWriteStrategy getExpirationStrategy() {
        return this.request.getExpirationStrategy();
    }

    protected long getCurrentTimeNanos() {
        return this.currentTimeNanos;
    }
}

