/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.optimization.batch;

import io.github.bucket4j.distributed.proxy.AsyncCommandExecutor;
import io.github.bucket4j.distributed.proxy.optimization.OptimizationListener;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MultiResult;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.commands.MultiCommand;
import io.github.bucket4j.util.concurrent.batch.AsyncBatchHelper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;

public class AsyncBatchingExecutor
implements AsyncCommandExecutor {
    private final AsyncBatchHelper<RemoteCommand<?>, CommandResult<?>, MultiCommand, CommandResult<MultiResult>> batchingHelper;
    private final AsyncCommandExecutor wrappedExecutor;

    public AsyncBatchingExecutor(AsyncCommandExecutor originalExecutor, final OptimizationListener listener) {
        this.wrappedExecutor = originalExecutor;
        BiFunction combinedResultSplitter = new BiFunction<MultiCommand, CommandResult<MultiResult>, List<CommandResult<?>>>(){

            @Override
            public List<CommandResult<?>> apply(MultiCommand multiCommand, CommandResult<MultiResult> multiResult) {
                return multiCommand.unwrap(multiResult);
            }
        };
        Function taskExecutor = new Function<RemoteCommand<?>, CompletableFuture<CommandResult<?>>>(){

            @Override
            public CompletableFuture<CommandResult<?>> apply(RemoteCommand<?> remoteCommand) {
                CompletableFuture<CommandResult<?>> future = AsyncBatchingExecutor.this.wrappedExecutor.executeAsync(remoteCommand);
                return future;
            }
        };
        Function<MultiCommand, CompletableFuture<CommandResult<MultiResult>>> combinedTaskExecutor = new Function<MultiCommand, CompletableFuture<CommandResult<MultiResult>>>(){

            @Override
            public CompletableFuture<CommandResult<MultiResult>> apply(MultiCommand multiCommand) {
                return AsyncBatchingExecutor.this.wrappedExecutor.executeAsync(multiCommand);
            }
        };
        Function taskCombiner = new Function<List<RemoteCommand<?>>, MultiCommand>(){

            @Override
            public MultiCommand apply(List<RemoteCommand<?>> commands) {
                if (commands.size() > 1) {
                    listener.incrementMergeCount(commands.size() - 1);
                }
                return MultiCommand.merge(commands);
            }
        };
        this.batchingHelper = AsyncBatchHelper.create(taskCombiner, combinedTaskExecutor, taskExecutor, combinedResultSplitter);
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(RemoteCommand<T> command) {
        CompletableFuture<CommandResult<T>> future = this.batchingHelper.executeAsync(command);
        return future;
    }
}

