/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.proxy.RecoveryStrategy;
import io.github.bucket4j.distributed.proxy.RemoteAsyncBucketBuilder;
import io.github.bucket4j.distributed.proxy.optimization.Optimization;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public class RemoteAsyncBucketBuilderView<K, KeyOld>
implements RemoteAsyncBucketBuilder<K> {
    private final RemoteAsyncBucketBuilder<KeyOld> target;
    private final Function<K, KeyOld> mapper;

    public RemoteAsyncBucketBuilderView(RemoteAsyncBucketBuilder<KeyOld> target, Function<K, KeyOld> mapper) {
        this.target = target;
        this.mapper = mapper;
    }

    @Override
    public RemoteAsyncBucketBuilder<K> withRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
        this.target.withRecoveryStrategy(recoveryStrategy);
        return this;
    }

    @Override
    public RemoteAsyncBucketBuilder<K> withOptimization(Optimization optimization) {
        this.target.withOptimization(optimization);
        return this;
    }

    @Override
    public RemoteAsyncBucketBuilder<K> withImplicitConfigurationReplacement(long desiredConfigurationVersion, TokensInheritanceStrategy tokensInheritanceStrategy) {
        this.target.withImplicitConfigurationReplacement(desiredConfigurationVersion, tokensInheritanceStrategy);
        return this;
    }

    @Override
    public RemoteAsyncBucketBuilder<K> withListener(BucketListener listener) {
        this.target.withListener(listener);
        return this;
    }

    @Override
    public AsyncBucketProxy build(K key, BucketConfiguration configuration) {
        return this.target.build(this.mapper.apply(key), configuration);
    }

    @Override
    public AsyncBucketProxy build(K key, Supplier<CompletableFuture<BucketConfiguration>> configurationSupplier) {
        return this.target.build(this.mapper.apply(key), configurationSupplier);
    }

    @Override
    public <K2> RemoteAsyncBucketBuilder<K2> withMapper(Function<? super K2, ? extends K> innerMapper) {
        return this.target.withMapper(this.mapper.compose(innerMapper));
    }
}

