/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.distributed.BucketProxy;
import io.github.bucket4j.distributed.proxy.AsyncProxyManager;
import io.github.bucket4j.distributed.proxy.ProxyManager;
import io.github.bucket4j.distributed.proxy.RemoteBucketBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class ProxyManagerView<K, KeyOld>
implements ProxyManager<K> {
    private final ProxyManager<KeyOld> target;
    private final Function<K, KeyOld> mapper;

    public ProxyManagerView(ProxyManager<KeyOld> target, Function<K, KeyOld> mapper) {
        this.target = target;
        this.mapper = mapper;
    }

    @Override
    public BucketProxy getProxy(K key, Supplier<BucketConfiguration> configurationSupplier) {
        return this.target.getProxy(this.mapper.apply(key), configurationSupplier);
    }

    @Override
    public RemoteBucketBuilder<K> builder() {
        return this.target.builder().withMapper(this.mapper);
    }

    @Override
    public Optional<BucketConfiguration> getProxyConfiguration(K key) {
        return this.target.getProxyConfiguration(this.mapper.apply(key));
    }

    @Override
    public void removeProxy(K key) {
        this.target.removeProxy(this.mapper.apply(key));
    }

    @Override
    public boolean isAsyncModeSupported() {
        return this.target.isAsyncModeSupported();
    }

    @Override
    public boolean isExpireAfterWriteSupported() {
        return this.target.isExpireAfterWriteSupported();
    }

    @Override
    public AsyncProxyManager<K> asAsync() throws UnsupportedOperationException {
        return this.target.asAsync().withMapper(this.mapper);
    }

    @Override
    public <K2> ProxyManager<K2> withMapper(Function<? super K2, ? extends K> innerMapper) {
        return this.target.withMapper(this.mapper.compose(innerMapper));
    }
}

