/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.VerboseResult;
import io.github.bucket4j.distributed.BucketProxy;
import io.github.bucket4j.distributed.OptimizationController;
import io.github.bucket4j.distributed.proxy.BucketNotFoundException;
import io.github.bucket4j.distributed.proxy.CommandExecutor;
import io.github.bucket4j.distributed.proxy.ImplicitConfigurationReplacement;
import io.github.bucket4j.distributed.proxy.RecoveryStrategy;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.RemoteVerboseResult;
import io.github.bucket4j.distributed.remote.commands.AddTokensCommand;
import io.github.bucket4j.distributed.remote.commands.CheckConfigurationVersionAndExecuteCommand;
import io.github.bucket4j.distributed.remote.commands.ConsumeAsMuchAsPossibleCommand;
import io.github.bucket4j.distributed.remote.commands.ConsumeIgnoringRateLimitsCommand;
import io.github.bucket4j.distributed.remote.commands.CreateInitialStateAndExecuteCommand;
import io.github.bucket4j.distributed.remote.commands.CreateInitialStateWithVersionOrReplaceConfigurationAndExecuteCommand;
import io.github.bucket4j.distributed.remote.commands.EstimateAbilityToConsumeCommand;
import io.github.bucket4j.distributed.remote.commands.ForceAddTokensCommand;
import io.github.bucket4j.distributed.remote.commands.GetAvailableTokensCommand;
import io.github.bucket4j.distributed.remote.commands.ReplaceConfigurationCommand;
import io.github.bucket4j.distributed.remote.commands.ReserveAndCalculateTimeToSleepCommand;
import io.github.bucket4j.distributed.remote.commands.ResetCommand;
import io.github.bucket4j.distributed.remote.commands.SyncCommand;
import io.github.bucket4j.distributed.remote.commands.TryConsumeAndReturnRemainingTokensCommand;
import io.github.bucket4j.distributed.remote.commands.TryConsumeCommand;
import io.github.bucket4j.util.ComparableByContent;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class DefaultBucketProxy
extends AbstractBucket
implements BucketProxy,
OptimizationController {
    private final CommandExecutor commandExecutor;
    private final RecoveryStrategy recoveryStrategy;
    private final Supplier<BucketConfiguration> configurationSupplier;
    private final ImplicitConfigurationReplacement implicitConfigurationReplacement;
    private final AtomicBoolean wasInitialized;

    @Override
    public BucketProxy toListenable(BucketListener listener) {
        return new DefaultBucketProxy(this.configurationSupplier, this.commandExecutor, this.recoveryStrategy, this.wasInitialized, this.implicitConfigurationReplacement, listener);
    }

    @Override
    public OptimizationController getOptimizationController() {
        return this;
    }

    @Override
    public void syncByCondition(long unsynchronizedTokens, Duration timeSinceLastSync) {
        this.execute(new SyncCommand(unsynchronizedTokens, timeSinceLastSync.toNanos()));
    }

    public DefaultBucketProxy(Supplier<BucketConfiguration> configurationSupplier, CommandExecutor commandExecutor, RecoveryStrategy recoveryStrategy, ImplicitConfigurationReplacement implicitConfigurationReplacement, BucketListener listener) {
        this(configurationSupplier, commandExecutor, recoveryStrategy, new AtomicBoolean(false), implicitConfigurationReplacement, listener);
    }

    private DefaultBucketProxy(Supplier<BucketConfiguration> configurationSupplier, CommandExecutor commandExecutor, RecoveryStrategy recoveryStrategy, AtomicBoolean wasInitialized, ImplicitConfigurationReplacement implicitConfigurationReplacement, BucketListener listener) {
        super(listener);
        this.commandExecutor = Objects.requireNonNull(commandExecutor);
        this.recoveryStrategy = Objects.requireNonNull(recoveryStrategy);
        if (configurationSupplier == null) {
            throw BucketExceptions.nullConfigurationSupplier();
        }
        this.configurationSupplier = configurationSupplier;
        this.implicitConfigurationReplacement = implicitConfigurationReplacement;
        this.wasInitialized = wasInitialized;
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        return this.execute(new ConsumeAsMuchAsPossibleCommand(limit));
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        return this.execute(TryConsumeCommand.create(tokensToConsume));
    }

    @Override
    protected ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long tokensToConsume) {
        return this.execute(new TryConsumeAndReturnRemainingTokensCommand(tokensToConsume));
    }

    @Override
    protected EstimationProbe estimateAbilityToConsumeImpl(long numTokens) {
        return this.execute(new EstimateAbilityToConsumeCommand(numTokens));
    }

    @Override
    protected long reserveAndCalculateTimeToSleepImpl(long tokensToConsume, long maxWaitTimeNanos) {
        ReserveAndCalculateTimeToSleepCommand consumeCommand = new ReserveAndCalculateTimeToSleepCommand(tokensToConsume, maxWaitTimeNanos);
        return this.execute(consumeCommand);
    }

    @Override
    protected VerboseResult<Long> reserveAndCalculateTimeToSleepVerboseImpl(long tokensToConsume, long maxWaitTimeNanos) {
        ReserveAndCalculateTimeToSleepCommand consumeCommand = new ReserveAndCalculateTimeToSleepCommand(tokensToConsume, maxWaitTimeNanos);
        return ((RemoteVerboseResult)this.execute(consumeCommand.asVerbose())).asLocal();
    }

    @Override
    protected void addTokensImpl(long tokensToAdd) {
        this.execute(new AddTokensCommand(tokensToAdd));
    }

    @Override
    protected void forceAddTokensImpl(long tokensToAdd) {
        this.execute(new ForceAddTokensCommand(tokensToAdd));
    }

    @Override
    protected void replaceConfigurationImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        this.execute(new ReplaceConfigurationCommand(newConfiguration, tokensInheritanceStrategy));
    }

    @Override
    protected long consumeIgnoringRateLimitsImpl(long tokensToConsume) {
        ConsumeIgnoringRateLimitsCommand command = new ConsumeIgnoringRateLimitsCommand(tokensToConsume);
        return this.execute(command);
    }

    @Override
    public void reset() {
        ResetCommand command = new ResetCommand();
        this.execute(command);
    }

    @Override
    public long getAvailableTokens() {
        return this.execute(new GetAvailableTokensCommand());
    }

    @Override
    protected VerboseResult<Long> consumeAsMuchAsPossibleVerboseImpl(long limit) {
        ConsumeAsMuchAsPossibleCommand command = new ConsumeAsMuchAsPossibleCommand(limit);
        return ((RemoteVerboseResult)this.execute(command.asVerbose())).asLocal();
    }

    @Override
    protected VerboseResult<Boolean> tryConsumeVerboseImpl(long tokensToConsume) {
        TryConsumeCommand command = TryConsumeCommand.create(tokensToConsume);
        return ((RemoteVerboseResult)this.execute(command.asVerbose())).asLocal();
    }

    @Override
    protected VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemainingTokensVerboseImpl(long tokensToConsume) {
        TryConsumeAndReturnRemainingTokensCommand command = new TryConsumeAndReturnRemainingTokensCommand(tokensToConsume);
        return ((RemoteVerboseResult)this.execute(command.asVerbose())).asLocal();
    }

    @Override
    protected VerboseResult<EstimationProbe> estimateAbilityToConsumeVerboseImpl(long numTokens) {
        EstimateAbilityToConsumeCommand command = new EstimateAbilityToConsumeCommand(numTokens);
        return ((RemoteVerboseResult)this.execute(command.asVerbose())).asLocal();
    }

    @Override
    protected VerboseResult<Long> getAvailableTokensVerboseImpl() {
        GetAvailableTokensCommand command = new GetAvailableTokensCommand();
        return ((RemoteVerboseResult)this.execute(command.asVerbose())).asLocal();
    }

    @Override
    protected VerboseResult<Nothing> addTokensVerboseImpl(long tokensToAdd) {
        AddTokensCommand command = new AddTokensCommand(tokensToAdd);
        return ((RemoteVerboseResult)this.execute(command.asVerbose())).asLocal();
    }

    @Override
    protected VerboseResult<Nothing> forceAddTokensVerboseImpl(long tokensToAdd) {
        ForceAddTokensCommand command = new ForceAddTokensCommand(tokensToAdd);
        return ((RemoteVerboseResult)this.execute(command.asVerbose())).asLocal();
    }

    @Override
    protected VerboseResult<Nothing> resetVerboseImpl() {
        ResetCommand command = new ResetCommand();
        return ((RemoteVerboseResult)this.execute(command.asVerbose())).asLocal();
    }

    @Override
    protected VerboseResult<Nothing> replaceConfigurationVerboseImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        ReplaceConfigurationCommand replaceConfigCommand = new ReplaceConfigurationCommand(newConfiguration, tokensInheritanceStrategy);
        return ((RemoteVerboseResult)this.execute(replaceConfigCommand.asVerbose())).asLocal();
    }

    @Override
    protected VerboseResult<Long> consumeIgnoringRateLimitsVerboseImpl(long tokensToConsume) {
        ConsumeIgnoringRateLimitsCommand command = new ConsumeIgnoringRateLimitsCommand(tokensToConsume);
        return ((RemoteVerboseResult)this.execute(command.asVerbose())).asLocal();
    }

    private BucketConfiguration getConfiguration() {
        BucketConfiguration bucketConfiguration = this.configurationSupplier.get();
        if (bucketConfiguration == null) {
            throw BucketExceptions.nullConfiguration();
        }
        return bucketConfiguration;
    }

    private <T> T execute(RemoteCommand<T> command) {
        if (this.implicitConfigurationReplacement != null) {
            command = new CheckConfigurationVersionAndExecuteCommand<T>(command, this.implicitConfigurationReplacement.getDesiredConfigurationVersion());
        }
        boolean wasInitializedBeforeExecution = this.wasInitialized.get();
        CommandResult<T> result = this.commandExecutor.execute(command);
        if (!result.isBucketNotFound() && !result.isConfigurationNeedToBeReplaced()) {
            return result.getData();
        }
        if (result.isBucketNotFound() && this.recoveryStrategy == RecoveryStrategy.THROW_BUCKET_NOT_FOUND_EXCEPTION && wasInitializedBeforeExecution) {
            throw new BucketNotFoundException();
        }
        ComparableByContent<CreateInitialStateAndExecuteCommand> initAndExecuteCommand = this.implicitConfigurationReplacement == null ? new CreateInitialStateAndExecuteCommand<T>(this.getConfiguration(), command) : new CreateInitialStateWithVersionOrReplaceConfigurationAndExecuteCommand<T>(this.getConfiguration(), command, this.implicitConfigurationReplacement.getDesiredConfigurationVersion(), this.implicitConfigurationReplacement.getTokensInheritanceStrategy());
        CommandResult<T> resultAfterInitialization = this.commandExecutor.execute(initAndExecuteCommand);
        if (resultAfterInitialization.isBucketNotFound()) {
            throw new IllegalStateException("Bucket is not initialized properly");
        }
        T data = resultAfterInitialization.getData();
        this.wasInitialized.set(true);
        return data;
    }
}

