/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.ExecutionStrategy;
import io.github.bucket4j.distributed.proxy.ProxyManager;
import io.github.bucket4j.distributed.proxy.RecoveryStrategy;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractProxyManagerBuilder<K, P extends ProxyManager<K>, B extends AbstractProxyManagerBuilder<K, P, B>> {
    private Version backwardCompatibilityVersion = Versions.getLatest();
    private Optional<TimeMeter> clientSideClock = Optional.empty();
    private ExecutionStrategy executionStrategy = ExecutionStrategy.SAME_TREAD;
    private Optional<Long> requestTimeoutNanos = Optional.empty();
    private Optional<ExpirationAfterWriteStrategy> expirationStrategy = Optional.empty();
    private BucketListener defaultListener = BucketListener.NOPE;
    private RecoveryStrategy defaultRecoveryStrategy = RecoveryStrategy.RECONSTRUCT;

    public B backwardCompatibleWith(Version backwardCompatibilityVersion) {
        this.backwardCompatibilityVersion = Objects.requireNonNull(backwardCompatibilityVersion);
        return (B)this;
    }

    public B clientClock(TimeMeter clientClock) {
        Objects.requireNonNull(this.clientSideClock);
        if (!clientClock.isWallClockBased()) {
            throw BucketExceptions.isNotWallBasedClockUsedInDistributedEnvironment(clientClock.getClass());
        }
        this.clientSideClock = Optional.of(clientClock);
        return (B)this;
    }

    public B executionStrategy(ExecutionStrategy executionStrategy) {
        this.executionStrategy = Objects.requireNonNull(executionStrategy);
        return (B)this;
    }

    public B requestTimeout(Duration requestTimeout) {
        Objects.requireNonNull(requestTimeout);
        if (requestTimeout.isZero() || requestTimeout.isNegative()) {
            throw BucketExceptions.nonPositiveRequestTimeout(requestTimeout);
        }
        this.requestTimeoutNanos = Optional.of(requestTimeout.toNanos());
        return (B)this;
    }

    public B expirationAfterWrite(ExpirationAfterWriteStrategy expirationStrategy) {
        if (expirationStrategy != null && !this.isExpireAfterWriteSupported()) {
            throw BucketExceptions.expirationAfterWriteIsNotSupported();
        }
        this.expirationStrategy = Optional.ofNullable(expirationStrategy);
        return (B)this;
    }

    public B defaultListener(BucketListener defaultListener) {
        this.defaultListener = Objects.requireNonNull(defaultListener);
        return (B)this;
    }

    public B defaultRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
        this.defaultRecoveryStrategy = Objects.requireNonNull(recoveryStrategy);
        return (B)this;
    }

    public Optional<ExpirationAfterWriteStrategy> getExpirationAfterWrite() {
        return this.expirationStrategy;
    }

    public Optional<TimeMeter> getClientSideClock() {
        return this.clientSideClock;
    }

    public Optional<Long> getRequestTimeoutNanos() {
        return this.requestTimeoutNanos;
    }

    public Version getBackwardCompatibilityVersion() {
        return this.backwardCompatibilityVersion;
    }

    public ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    public abstract P build();

    public boolean isExpireAfterWriteSupported() {
        return false;
    }

    public ClientSideConfig getClientSideConfig() {
        return new ClientSideConfig(this.backwardCompatibilityVersion, this.clientSideClock, this.executionStrategy, this.requestTimeoutNanos, this.expirationStrategy, this.defaultListener, this.defaultRecoveryStrategy);
    }
}

