/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.jdbc;

import io.github.bucket4j.distributed.jdbc.CustomColumnProvider;
import io.github.bucket4j.distributed.jdbc.PrimaryKeyMapper;
import io.github.bucket4j.distributed.proxy.AbstractProxyManagerBuilder;
import io.github.bucket4j.distributed.proxy.ProxyManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;

public abstract class AbstractJdbcProxyManagerBuilder<K, P extends ProxyManager<K>, B extends AbstractJdbcProxyManagerBuilder<K, P, B>>
extends AbstractProxyManagerBuilder<K, P, B> {
    private final DataSource dataSource;
    protected PrimaryKeyMapper<K> primaryKeyMapper;
    private String tableName = "bucket";
    private String idColumnName = "id";
    private String stateColumnName = "state";
    private String expiresAtColumnName = "expires_at";
    private final List<CustomColumnProvider<K>> customColumns = new ArrayList<CustomColumnProvider<K>>();

    public AbstractJdbcProxyManagerBuilder(DataSource dataSource, PrimaryKeyMapper<K> primaryKeyMapper) {
        this.dataSource = Objects.requireNonNull(dataSource);
        this.primaryKeyMapper = Objects.requireNonNull(primaryKeyMapper);
    }

    public B table(String tableName) {
        this.tableName = Objects.requireNonNull(tableName);
        return (B)this;
    }

    public B idColumn(String idColumnName) {
        this.idColumnName = Objects.requireNonNull(idColumnName);
        return (B)this;
    }

    public B stateColumn(String stateColumnName) {
        this.stateColumnName = Objects.requireNonNull(stateColumnName);
        return (B)this;
    }

    public B expiresAtColumn(String expiresAtColumnName) {
        this.expiresAtColumnName = Objects.requireNonNull(expiresAtColumnName);
        return (B)this;
    }

    public B addCustomColumn(CustomColumnProvider<K> column) {
        if (column.getCustomFieldName() == null) {
            throw new IllegalArgumentException("column.customFieldName must not be null");
        }
        this.customColumns.forEach(addedColumn -> {
            if (addedColumn.getCustomFieldName().equals(column.getCustomFieldName())) {
                throw new IllegalArgumentException("column with name " + column.getCustomFieldName() + " is already configured");
            }
        });
        this.customColumns.add(column);
        return (B)this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public PrimaryKeyMapper<K> getPrimaryKeyMapper() {
        return this.primaryKeyMapper;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getIdColumnName() {
        return this.idColumnName;
    }

    public String getStateColumnName() {
        return this.stateColumnName;
    }

    public String getExpiresAtColumnName() {
        return this.expiresAtColumnName;
    }

    public List<CustomColumnProvider<K>> getCustomColumns() {
        return Collections.unmodifiableList(this.customColumns);
    }
}

