/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.transform;

import io.aiven.kafka.tieredstorage.manifest.index.AbstractChunkIndexBuilder;
import io.aiven.kafka.tieredstorage.manifest.index.ChunkIndex;
import io.aiven.kafka.tieredstorage.manifest.index.FixedSizeChunkIndexBuilder;
import io.aiven.kafka.tieredstorage.manifest.index.VariableSizeChunkIndexBuilder;
import io.aiven.kafka.tieredstorage.transform.BaseTransformChunkEnumeration;
import io.aiven.kafka.tieredstorage.transform.RateLimitedInputStream;
import io.aiven.kafka.tieredstorage.transform.TransformChunkEnumeration;
import io.github.bucket4j.Bucket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;

public class TransformFinisher
implements Enumeration<InputStream> {
    private final TransformChunkEnumeration inner;
    private final AbstractChunkIndexBuilder chunkIndexBuilder;
    private final Path originalFilePath;
    private final int originalFileSize;
    private ChunkIndex chunkIndex = null;
    private final Bucket rateLimitingBucket;

    public static Builder newBuilder(TransformChunkEnumeration inner, int originalFileSize) {
        return new Builder(inner, originalFileSize);
    }

    private TransformFinisher(TransformChunkEnumeration inner, boolean chunkingEnabled, Path originalFilePath, int originalFileSize, Bucket rateLimitingBucket) {
        this.inner = Objects.requireNonNull(inner, "inner cannot be null");
        int originalChunkSize = chunkingEnabled ? inner.originalChunkSize() : originalFileSize;
        this.chunkIndexBuilder = TransformFinisher.chunkIndexBuilder(inner, originalChunkSize, originalFileSize);
        this.originalFilePath = originalFilePath;
        this.originalFileSize = originalFileSize;
        this.rateLimitingBucket = rateLimitingBucket;
    }

    private static AbstractChunkIndexBuilder chunkIndexBuilder(TransformChunkEnumeration inner, int originalChunkSize, int originalFileSize) {
        Integer transformedChunkSize = inner.transformedChunkSize();
        if (transformedChunkSize == null) {
            return new VariableSizeChunkIndexBuilder(originalChunkSize, originalFileSize);
        }
        return new FixedSizeChunkIndexBuilder(originalChunkSize, originalFileSize, transformedChunkSize);
    }

    @Override
    public boolean hasMoreElements() {
        return this.inner.hasMoreElements();
    }

    @Override
    public InputStream nextElement() {
        byte[] chunk = (byte[])this.inner.nextElement();
        if (this.hasMoreElements()) {
            this.chunkIndexBuilder.addChunk(chunk.length);
        } else {
            this.chunkIndex = this.chunkIndexBuilder.finish(chunk.length);
        }
        return new ByteArrayInputStream(chunk);
    }

    public ChunkIndex chunkIndex() {
        if (this.chunkIndex == null) {
            if (this.isBaseTransform()) {
                return this.calculateChunkIndex();
            }
            throw new IllegalStateException("Chunk index was not built, was finisher used?");
        }
        return this.chunkIndex;
    }

    private ChunkIndex calculateChunkIndex() {
        int size;
        Integer chunkSize = this.inner.transformedChunkSize();
        for (size = this.originalFileSize; size > chunkSize; size -= chunkSize.intValue()) {
            this.chunkIndexBuilder.addChunk(chunkSize);
        }
        return this.chunkIndexBuilder.finish(size);
    }

    public InputStream toInputStream() throws IOException {
        if (this.isBaseTransform() && this.originalFilePath != null) {
            SequenceInputStream sequenceInputStream = new SequenceInputStream(this);
            sequenceInputStream.close();
            return this.maybeToRateLimitedInputStream(Files.newInputStream(this.originalFilePath, new OpenOption[0]));
        }
        return this.maybeToRateLimitedInputStream(new SequenceInputStream(this));
    }

    private InputStream maybeToRateLimitedInputStream(InputStream delegated) {
        if (this.rateLimitingBucket == null) {
            return delegated;
        }
        return new RateLimitedInputStream(delegated, this.rateLimitingBucket);
    }

    private boolean isBaseTransform() {
        return this.inner instanceof BaseTransformChunkEnumeration;
    }

    Optional<Path> maybeOriginalFilePath() {
        return Optional.ofNullable(this.originalFilePath);
    }

    public static class Builder {
        final TransformChunkEnumeration inner;
        final Integer originalFileSize;
        boolean chunkingEnabled = true;
        Path originalFilePath = null;
        Bucket rateLimitingBucket;

        public Builder(TransformChunkEnumeration inner, int originalFileSize) {
            this.inner = inner;
            if (originalFileSize < 0) {
                throw new IllegalArgumentException("originalFileSize must be non-negative, " + originalFileSize + " given");
            }
            this.originalFileSize = originalFileSize;
        }

        public Builder withRateLimitingBucket(Bucket rateLimitingBucket) {
            this.rateLimitingBucket = rateLimitingBucket;
            return this;
        }

        public Builder withChunkingDisabled() {
            this.chunkingEnabled = false;
            return this;
        }

        public Builder withOriginalFilePath(Path originalFilePath) {
            this.originalFilePath = Objects.requireNonNull(originalFilePath, "originalFilePath cannot be null");
            return this;
        }

        public TransformFinisher build() {
            return new TransformFinisher(this.inner, this.chunkingEnabled, this.originalFilePath, this.originalFileSize, this.rateLimitingBucket);
        }
    }
}

