/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.transform;

import io.aiven.kafka.tieredstorage.transform.TransformChunkEnumeration;
import java.util.Objects;
import java.util.function.Supplier;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class EncryptionChunkEnumeration
implements TransformChunkEnumeration {
    private final TransformChunkEnumeration inner;
    private final Supplier<Cipher> cipherSupplier;
    private final Integer transformedChunkSize;

    public EncryptionChunkEnumeration(TransformChunkEnumeration inner, Supplier<Cipher> cipherSupplier) {
        this.inner = Objects.requireNonNull(inner, "inner cannot be null");
        this.cipherSupplier = Objects.requireNonNull(cipherSupplier, "cipherSupplier cannot be null");
        Integer innerTransformedChunkSize = inner.transformedChunkSize();
        if (innerTransformedChunkSize == null) {
            this.transformedChunkSize = null;
        } else {
            Cipher cipher = cipherSupplier.get();
            this.transformedChunkSize = this.encryptedChunkSize(cipher, cipher.getIV().length, innerTransformedChunkSize);
        }
    }

    @Override
    public int originalChunkSize() {
        return this.inner.originalChunkSize();
    }

    @Override
    public Integer transformedChunkSize() {
        return this.transformedChunkSize;
    }

    @Override
    public boolean hasMoreElements() {
        return this.inner.hasMoreElements();
    }

    @Override
    public byte[] nextElement() {
        Cipher cipher = this.cipherSupplier.get();
        byte[] chunk = (byte[])this.inner.nextElement();
        byte[] iv = cipher.getIV();
        int transformedChunkSize = this.encryptedChunkSize(cipher, iv.length, chunk.length);
        byte[] transformedChunk = new byte[transformedChunkSize];
        System.arraycopy(iv, 0, transformedChunk, 0, iv.length);
        try {
            cipher.doFinal(chunk, 0, chunk.length, transformedChunk, iv.length);
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new RuntimeException(e);
        }
        return transformedChunk;
    }

    private int encryptedChunkSize(Cipher cipher, int ivSize, int inputChunkSize) {
        return ivSize + cipher.getOutputSize(inputChunkSize);
    }
}

