/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.transform;

import io.aiven.kafka.tieredstorage.transform.DetransformChunkEnumeration;
import java.util.Objects;
import java.util.function.Function;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class DecryptionChunkEnumeration
implements DetransformChunkEnumeration {
    private final DetransformChunkEnumeration inner;
    private final int ivSize;
    private final Function<byte[], Cipher> cipherSupplier;

    public DecryptionChunkEnumeration(DetransformChunkEnumeration inner, int ivSize, Function<byte[], Cipher> cipherSupplier) {
        this.inner = Objects.requireNonNull(inner, "inner cannot be null");
        if (ivSize <= 0) {
            throw new IllegalArgumentException("ivSize must be positive");
        }
        this.ivSize = ivSize;
        this.cipherSupplier = Objects.requireNonNull(cipherSupplier, "cipherSupplier cannot be null");
    }

    @Override
    public boolean hasMoreElements() {
        return this.inner.hasMoreElements();
    }

    @Override
    public byte[] nextElement() {
        byte[] chunk = (byte[])this.inner.nextElement();
        Cipher cipher = this.cipherSupplier.apply(chunk);
        try {
            return cipher.doFinal(chunk, this.ivSize, chunk.length - this.ivSize);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }
}

