/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.transform;

import com.github.luben.zstd.Zstd;
import io.aiven.kafka.tieredstorage.transform.DetransformChunkEnumeration;
import java.util.Objects;

public class DecompressionChunkEnumeration
implements DetransformChunkEnumeration {
    private final DetransformChunkEnumeration inner;

    public DecompressionChunkEnumeration(DetransformChunkEnumeration inner) {
        this.inner = Objects.requireNonNull(inner, "inner cannot be null");
    }

    @Override
    public boolean hasMoreElements() {
        return this.inner.hasMoreElements();
    }

    @Override
    public byte[] nextElement() {
        byte[] chunk = (byte[])this.inner.nextElement();
        long decompressedSize = Zstd.decompressedSize(chunk);
        if (decompressedSize < 0L) {
            throw new RuntimeException("Invalid decompressed size: " + decompressedSize);
        }
        return Zstd.decompress(chunk, (int)decompressedSize);
    }
}

