/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.transform;

import com.github.luben.zstd.ZstdCompressCtx;
import io.aiven.kafka.tieredstorage.transform.TransformChunkEnumeration;
import java.util.Objects;

public class CompressionChunkEnumeration
implements TransformChunkEnumeration {
    private final TransformChunkEnumeration inner;

    public CompressionChunkEnumeration(TransformChunkEnumeration inner) {
        this.inner = Objects.requireNonNull(inner, "inner cannot be null");
    }

    @Override
    public int originalChunkSize() {
        return this.inner.originalChunkSize();
    }

    @Override
    public Integer transformedChunkSize() {
        return null;
    }

    @Override
    public boolean hasMoreElements() {
        return this.inner.hasMoreElements();
    }

    @Override
    public byte[] nextElement() {
        byte[] chunk = (byte[])this.inner.nextElement();
        try (ZstdCompressCtx compressCtx = new ZstdCompressCtx();){
            try {
                compressCtx.setPledgedSrcSize(chunk.length);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            compressCtx.setContentSize(true);
            byte[] byArray = compressCtx.compress(chunk);
            return byArray;
        }
    }
}

