/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.transform;

import io.aiven.kafka.tieredstorage.transform.TransformChunkEnumeration;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Objects;

public class BaseTransformChunkEnumeration
implements TransformChunkEnumeration {
    private final InputStream inputStream;
    private final int originalChunkSize;
    private byte[] chunk = null;

    public BaseTransformChunkEnumeration(InputStream inputStream, int originalChunkSize) {
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream cannot be null");
        if (originalChunkSize < 0) {
            throw new IllegalArgumentException("originalChunkSize must be non-negative, " + originalChunkSize + " given");
        }
        this.originalChunkSize = originalChunkSize;
    }

    @Override
    public int originalChunkSize() {
        return this.originalChunkSize;
    }

    @Override
    public Integer transformedChunkSize() {
        return this.originalChunkSize;
    }

    @Override
    public boolean hasMoreElements() {
        this.fillChunkIfNeeded();
        return !this.endOfStreamReached();
    }

    @Override
    public byte[] nextElement() {
        this.fillChunkIfNeeded();
        if (this.endOfStreamReached()) {
            throw new NoSuchElementException();
        }
        byte[] result = this.chunk;
        this.chunk = null;
        return result;
    }

    private void fillChunkIfNeeded() {
        if (this.chunk != null) {
            return;
        }
        try {
            this.chunk = this.originalChunkSize != 0 ? this.inputStream.readNBytes(this.originalChunkSize) : this.inputStream.readAllBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean endOfStreamReached() {
        return this.chunk.length == 0;
    }
}

