/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.transform;

import io.aiven.kafka.tieredstorage.Chunk;
import io.aiven.kafka.tieredstorage.transform.DetransformChunkEnumeration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class BaseDetransformChunkEnumeration
implements DetransformChunkEnumeration {
    final InputStream inputStream;
    private boolean inputStreamClosed = false;
    private final Iterator<Chunk> chunksIter;
    private final boolean isEmpty;
    private byte[] chunk = null;

    public BaseDetransformChunkEnumeration(InputStream inputStream) {
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream cannot be null");
        this.isEmpty = true;
        this.chunksIter = Collections.emptyIterator();
    }

    public BaseDetransformChunkEnumeration(InputStream inputStream, List<Chunk> chunks) {
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream cannot be null");
        this.chunksIter = Objects.requireNonNull(chunks, "chunks cannot be null").iterator();
        this.isEmpty = chunks.isEmpty();
    }

    @Override
    public boolean hasMoreElements() {
        this.fillChunkIfNeeded();
        return !this.endOfStreamReached();
    }

    @Override
    public byte[] nextElement() {
        this.fillChunkIfNeeded();
        if (this.endOfStreamReached()) {
            throw new NoSuchElementException();
        }
        byte[] result = this.chunk;
        this.chunk = null;
        return result;
    }

    private void fillChunkIfNeeded() {
        if (this.chunk != null) {
            return;
        }
        if (!this.chunksIter.hasNext() && !this.isEmpty) {
            this.chunk = new byte[0];
            if (!this.inputStreamClosed) {
                try {
                    this.inputStream.close();
                    this.inputStreamClosed = true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        if (this.inputStreamClosed) {
            throw new RuntimeException("Input stream already closed");
        }
        try {
            if (!this.isEmpty) {
                int expectedTransformedSize = this.chunksIter.next().transformedSize;
                this.chunk = this.inputStream.readNBytes(expectedTransformedSize);
                if (this.chunk.length < expectedTransformedSize) {
                    throw new RuntimeException("Stream has fewer bytes than expected");
                }
            } else {
                this.chunk = this.inputStream.readAllBytes();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean endOfStreamReached() {
        return this.chunk.length == 0;
    }
}

