/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.storage.proxy;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Objects;

public class Socks5ProxyAuthenticator
extends Authenticator {
    private final HashMap<InetSocketAddress, PasswordAuthentication> credentials = new HashMap();

    public static synchronized void register(String host, int port, String username, String password) {
        Authenticator currentDefault = Authenticator.getDefault();
        if (currentDefault != null) {
            if (!(currentDefault instanceof Socks5ProxyAuthenticator)) {
                throw new RuntimeException("Another Authenticator already registered");
            }
            ((Socks5ProxyAuthenticator)currentDefault).addCredentials(host, port, username, password);
        } else {
            Socks5ProxyAuthenticator authenticator = new Socks5ProxyAuthenticator();
            Authenticator.setDefault(authenticator);
            authenticator.addCredentials(host, port, username, password);
        }
    }

    void addCredentials(String host, int port, String username, String password) {
        Objects.requireNonNull(host, "host cannot be null");
        if (port <= 0) {
            throw new IllegalArgumentException("port must be positive");
        }
        Objects.requireNonNull(username, "username cannot be null");
        Objects.requireNonNull(password, "password cannot be null");
        InetSocketAddress hostAndPort = InetSocketAddress.createUnresolved(host, port);
        if (this.credentials.containsKey(hostAndPort)) {
            throw new RuntimeException("Credentials already registered for this host ans port");
        }
        this.credentials.put(hostAndPort, new PasswordAuthentication(username, password.toCharArray()));
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (!"SOCKS5".equals(this.getRequestingProtocol())) {
            return null;
        }
        InetSocketAddress hostAndPort = InetSocketAddress.createUnresolved(this.getRequestingHost(), this.getRequestingPort());
        return this.credentials.get(hostAndPort);
    }
}

