/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.storage.proxy;

import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;

public class ProxyConfig
extends AbstractConfig {
    public static final String PROXY_PREFIX = "proxy.";
    private static final String PROXY_HOST = "host";
    private static final String PROXY_HOST_DOC = "The SOCKS5 proxy host name or IP address";
    private static final String PROXY_PORT = "port";
    private static final String PROXY_PORT_DOC = "The SOCKS5 proxy port";
    private static final String PROXY_USERNAME = "username";
    private static final String PROXY_USERNAME_DOC = "The username for authentication at the SOCKS5 proxy";
    private static final String PROXY_PASSWORD = "password";
    private static final String PROXY_PASSWORD_DOC = "The password for authentication at the SOCKS5 proxy";
    private static final ConfigDef CONFIG = new ConfigDef();

    public ProxyConfig(Map<String, ?> props) {
        super(CONFIG, props);
        this.validate();
    }

    private void validate() {
        if (this.username() == null && this.password() != null || this.username() != null && this.password() == null) {
            throw new ConfigException("Username and password must be provided together");
        }
    }

    public String host() {
        return this.getString(PROXY_HOST);
    }

    public int port() {
        return this.getInt(PROXY_PORT);
    }

    public String username() {
        Password secret = this.getPassword(PROXY_USERNAME);
        return secret != null ? secret.value() : null;
    }

    public String password() {
        Password secret = this.getPassword(PROXY_PASSWORD);
        return secret != null ? secret.value() : null;
    }

    static {
        CONFIG.define(PROXY_HOST, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.LOW, PROXY_HOST_DOC);
        CONFIG.define(PROXY_PORT, ConfigDef.Type.INT, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.LOW, PROXY_PORT_DOC);
        CONFIG.define(PROXY_USERNAME, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.LOW, PROXY_USERNAME_DOC);
        CONFIG.define(PROXY_PASSWORD, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.LOW, PROXY_PASSWORD_DOC);
    }
}

