/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.tieredstorage.storage;

import java.util.OptionalInt;

public class BytesRange {
    final int from;
    final int to;

    BytesRange(int from, int to) {
        if (from < 0) {
            throw new IllegalArgumentException("from cannot be negative, " + from + " given");
        }
        if (to != -1 && to < from) {
            throw new IllegalArgumentException("to cannot be less than from, from=" + from + ", to=" + to + " given");
        }
        this.from = from;
        this.to = to;
    }

    public int firstPosition() {
        return this.from;
    }

    public OptionalInt maybeLastPosition() {
        if (this.isEmpty()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.to);
    }

    public int lastPosition() {
        if (this.isEmpty()) {
            throw new IllegalStateException("No last position, range is empty");
        }
        return this.to;
    }

    public boolean isEmpty() {
        return this.to == -1;
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.to - this.from + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesRange that = (BytesRange)o;
        return this.from == that.from && this.to == that.to;
    }

    public int hashCode() {
        int result = this.from;
        result = 31 * result + this.to;
        return result;
    }

    public String toString() {
        return "BytesRange{position=" + this.firstPosition() + ", size=" + this.size() + "}";
    }

    public static BytesRange of(int from, int to) {
        return new BytesRange(from, to);
    }

    public static BytesRange empty(int from) {
        return new BytesRange(from, -1);
    }

    public static BytesRange ofFromPositionAndSize(int from, int size) {
        if (size == 0) {
            return BytesRange.empty(from);
        }
        return new BytesRange(from, from + size - 1);
    }
}

